/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.lambda.model.CreateFunctionRequest;
import com.amazonaws.services.lambda.model.FunctionCode;
import com.amazonaws.services.lambda.model.VpcConfig;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CreateFunctionRequestMarshaller
implements Marshaller<Request<CreateFunctionRequest>, CreateFunctionRequest> {
    private static final String RESOURCE_PATH_TEMPLATE;
    private static final Map<String, String> STATIC_QUERY_PARAMS;
    private static final Map<String, String> DYNAMIC_QUERY_PARAMS;

    public Request<CreateFunctionRequest> marshall(CreateFunctionRequest createFunctionRequest) {
        if (createFunctionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createFunctionRequest, "AWSLambda");
        String target = "AWSLambda.CreateFunction";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = RESOURCE_PATH_TEMPLATE;
        request.setResourcePath(uriResourcePath.replaceAll("//", "/"));
        for (Map.Entry<String, String> entry : STATIC_QUERY_PARAMS.entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        try {
            VpcConfig vpcConfig;
            FunctionCode code;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (createFunctionRequest.getFunctionName() != null) {
                jsonWriter.key("FunctionName").value((Object)createFunctionRequest.getFunctionName());
            }
            if (createFunctionRequest.getRuntime() != null) {
                jsonWriter.key("Runtime").value((Object)createFunctionRequest.getRuntime());
            }
            if (createFunctionRequest.getRole() != null) {
                jsonWriter.key("Role").value((Object)createFunctionRequest.getRole());
            }
            if (createFunctionRequest.getHandler() != null) {
                jsonWriter.key("Handler").value((Object)createFunctionRequest.getHandler());
            }
            if ((code = createFunctionRequest.getCode()) != null) {
                jsonWriter.key("Code");
                jsonWriter.object();
                if (code.getZipFile() != null) {
                    jsonWriter.key("ZipFile").value(code.getZipFile());
                }
                if (code.getS3Bucket() != null) {
                    jsonWriter.key("S3Bucket").value((Object)code.getS3Bucket());
                }
                if (code.getS3Key() != null) {
                    jsonWriter.key("S3Key").value((Object)code.getS3Key());
                }
                if (code.getS3ObjectVersion() != null) {
                    jsonWriter.key("S3ObjectVersion").value((Object)code.getS3ObjectVersion());
                }
                jsonWriter.endObject();
            }
            if (createFunctionRequest.getDescription() != null) {
                jsonWriter.key("Description").value((Object)createFunctionRequest.getDescription());
            }
            if (createFunctionRequest.getTimeout() != null) {
                jsonWriter.key("Timeout").value((Object)createFunctionRequest.getTimeout());
            }
            if (createFunctionRequest.getMemorySize() != null) {
                jsonWriter.key("MemorySize").value((Object)createFunctionRequest.getMemorySize());
            }
            if (createFunctionRequest.isPublish() != null) {
                jsonWriter.key("Publish").value((Object)createFunctionRequest.isPublish());
            }
            if ((vpcConfig = createFunctionRequest.getVpcConfig()) != null) {
                ListWithAutoConstructFlag securityGroupIdsList;
                jsonWriter.key("VpcConfig");
                jsonWriter.object();
                ListWithAutoConstructFlag subnetIdsList = (ListWithAutoConstructFlag)vpcConfig.getSubnetIds();
                if (!(subnetIdsList == null || subnetIdsList.isAutoConstruct() && subnetIdsList.isEmpty())) {
                    jsonWriter.key("SubnetIds");
                    jsonWriter.array();
                    for (String subnetIdsListValue : subnetIdsList) {
                        if (subnetIdsListValue == null) continue;
                        jsonWriter.value((Object)subnetIdsListValue);
                    }
                    jsonWriter.endArray();
                }
                if (!((securityGroupIdsList = (ListWithAutoConstructFlag)vpcConfig.getSecurityGroupIds()) == null || securityGroupIdsList.isAutoConstruct() && securityGroupIdsList.isEmpty())) {
                    jsonWriter.key("SecurityGroupIds");
                    jsonWriter.array();
                    for (String securityGroupIdsListValue : securityGroupIdsList) {
                        if (securityGroupIdsListValue == null) continue;
                        jsonWriter.value((Object)securityGroupIdsListValue);
                    }
                    jsonWriter.endArray();
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }

    static {
        String path = "/2015-03-31/functions";
        HashMap<String, String> staticMap = new HashMap<String, String>();
        HashMap<String, String> dynamicMap = new HashMap<String, String>();
        int index = path.indexOf("?");
        if (index != -1) {
            String queryString = path.substring(index + 1);
            path = path.substring(0, index);
            for (String s : queryString.split("[;&]")) {
                index = s.indexOf("=");
                if (index == -1) continue;
                String name = s.substring(0, index);
                String value = s.substring(index + 1);
                if (value.startsWith("{") && value.endsWith("}")) {
                    dynamicMap.put(value.substring(1, value.length() - 1), name);
                    continue;
                }
                staticMap.put(name, value);
            }
        }
        RESOURCE_PATH_TEMPLATE = path;
        STATIC_QUERY_PARAMS = Collections.unmodifiableMap(staticMap);
        DYNAMIC_QUERY_PARAMS = Collections.unmodifiableMap(dynamicMap);
    }
}

