/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.services.kms.model.GrantConstraints;
import com.amazonaws.util.json.JSONWriter;
import java.util.Map;

public class GrantConstraintsJsonMarshaller {
    private static GrantConstraintsJsonMarshaller instance;

    public void marshall(GrantConstraints grantConstraints, JSONWriter jsonWriter) {
        if (grantConstraints == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalMap encryptionContextEqualsMap;
            jsonWriter.object();
            SdkInternalMap encryptionContextSubsetMap = (SdkInternalMap)grantConstraints.getEncryptionContextSubset();
            if (!encryptionContextSubsetMap.isEmpty() || !encryptionContextSubsetMap.isAutoConstruct()) {
                jsonWriter.key("EncryptionContextSubset");
                jsonWriter.object();
                for (Map.Entry encryptionContextSubsetMapValue : encryptionContextSubsetMap.entrySet()) {
                    if (encryptionContextSubsetMapValue.getValue() == null) continue;
                    jsonWriter.key((String)encryptionContextSubsetMapValue.getKey());
                    jsonWriter.value(encryptionContextSubsetMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            if (!(encryptionContextEqualsMap = (SdkInternalMap)grantConstraints.getEncryptionContextEquals()).isEmpty() || !encryptionContextEqualsMap.isAutoConstruct()) {
                jsonWriter.key("EncryptionContextEquals");
                jsonWriter.object();
                for (Map.Entry encryptionContextEqualsMapValue : encryptionContextEqualsMap.entrySet()) {
                    if (encryptionContextEqualsMapValue.getValue() == null) continue;
                    jsonWriter.key((String)encryptionContextEqualsMapValue.getKey());
                    jsonWriter.value(encryptionContextEqualsMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static GrantConstraintsJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new GrantConstraintsJsonMarshaller();
        }
        return instance;
    }
}

