/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model.transform;

import com.amazonaws.services.kinesis.model.Record;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;
import java.nio.ByteBuffer;

public class RecordJsonUnmarshaller
implements Unmarshaller<Record, JsonUnmarshallerContext> {
    private static RecordJsonUnmarshaller instance;

    public Record unmarshall(JsonUnmarshallerContext context) throws Exception {
        Record record = new Record();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("SequenceNumber", targetDepth)) {
                    context.nextToken();
                    record.setSequenceNumber((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ApproximateArrivalTimestamp", targetDepth)) {
                    context.nextToken();
                    record.setApproximateArrivalTimestamp(SimpleTypeJsonUnmarshallers.DateJsonUnmarshallerFactory.getInstance((String)"unixTimestamp").unmarshall(context));
                }
                if (context.testExpression("Data", targetDepth)) {
                    context.nextToken();
                    record.setData((ByteBuffer)context.getUnmarshaller(ByteBuffer.class).unmarshall((Object)context));
                }
                if (context.testExpression("PartitionKey", targetDepth)) {
                    context.nextToken();
                    record.setPartitionKey((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("EncryptionType", targetDepth)) {
                    context.nextToken();
                    record.setEncryptionType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return record;
    }

    public static RecordJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new RecordJsonUnmarshaller();
        }
        return instance;
    }
}

