/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.kinesis.model.Shard;
import com.amazonaws.services.kinesis.model.StreamDescription;
import com.amazonaws.services.kinesis.model.transform.ShardJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class StreamDescriptionJsonMarshaller {
    private static StreamDescriptionJsonMarshaller instance;

    public void marshall(StreamDescription streamDescription, JSONWriter jsonWriter) {
        if (streamDescription == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList shardsList;
            jsonWriter.object();
            if (streamDescription.getStreamName() != null) {
                jsonWriter.key("StreamName").value((Object)streamDescription.getStreamName());
            }
            if (streamDescription.getStreamARN() != null) {
                jsonWriter.key("StreamARN").value((Object)streamDescription.getStreamARN());
            }
            if (streamDescription.getStreamStatus() != null) {
                jsonWriter.key("StreamStatus").value((Object)streamDescription.getStreamStatus());
            }
            if (!(shardsList = (SdkInternalList)streamDescription.getShards()).isEmpty() || !shardsList.isAutoConstruct()) {
                jsonWriter.key("Shards");
                jsonWriter.array();
                for (Shard shardsListValue : shardsList) {
                    if (shardsListValue == null) continue;
                    ShardJsonMarshaller.getInstance().marshall(shardsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (streamDescription.getHasMoreShards() != null) {
                jsonWriter.key("HasMoreShards").value((Object)streamDescription.getHasMoreShards());
            }
            if (streamDescription.getRetentionPeriodHours() != null) {
                jsonWriter.key("RetentionPeriodHours").value((Object)streamDescription.getRetentionPeriodHours());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static StreamDescriptionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new StreamDescriptionJsonMarshaller();
        }
        return instance;
    }
}

