/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.keyspaces.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.keyspaces.model.EncryptionSpecification;

@SdkInternalApi
public class EncryptionSpecificationMarshaller {
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").build();
    private static final MarshallingInfo<String> KMSKEYIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("kmsKeyIdentifier").build();
    private static final EncryptionSpecificationMarshaller instance = new EncryptionSpecificationMarshaller();

    public static EncryptionSpecificationMarshaller getInstance() {
        return instance;
    }

    public void marshall(EncryptionSpecification encryptionSpecification, ProtocolMarshaller protocolMarshaller) {
        if (encryptionSpecification == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)encryptionSpecification.getType(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)encryptionSpecification.getKmsKeyIdentifier(), KMSKEYIDENTIFIER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

