/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kendra.model.WebCrawlerConfiguration;
import java.util.List;

@SdkInternalApi
public class WebCrawlerConfigurationMarshaller {
    private static final MarshallingInfo<StructuredPojo> URLS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Urls").build();
    private static final MarshallingInfo<Integer> CRAWLDEPTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CrawlDepth").build();
    private static final MarshallingInfo<Integer> MAXLINKSPERPAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxLinksPerPage").build();
    private static final MarshallingInfo<Float> MAXCONTENTSIZEPERPAGEINMEGABYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxContentSizePerPageInMegaBytes").build();
    private static final MarshallingInfo<Integer> MAXURLSPERMINUTECRAWLRATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxUrlsPerMinuteCrawlRate").build();
    private static final MarshallingInfo<List> URLINCLUSIONPATTERNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UrlInclusionPatterns").build();
    private static final MarshallingInfo<List> URLEXCLUSIONPATTERNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UrlExclusionPatterns").build();
    private static final MarshallingInfo<StructuredPojo> PROXYCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProxyConfiguration").build();
    private static final MarshallingInfo<StructuredPojo> AUTHENTICATIONCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AuthenticationConfiguration").build();
    private static final WebCrawlerConfigurationMarshaller instance = new WebCrawlerConfigurationMarshaller();

    public static WebCrawlerConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(WebCrawlerConfiguration webCrawlerConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (webCrawlerConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)webCrawlerConfiguration.getUrls(), URLS_BINDING);
            protocolMarshaller.marshall((Object)webCrawlerConfiguration.getCrawlDepth(), CRAWLDEPTH_BINDING);
            protocolMarshaller.marshall((Object)webCrawlerConfiguration.getMaxLinksPerPage(), MAXLINKSPERPAGE_BINDING);
            protocolMarshaller.marshall((Object)webCrawlerConfiguration.getMaxContentSizePerPageInMegaBytes(), MAXCONTENTSIZEPERPAGEINMEGABYTES_BINDING);
            protocolMarshaller.marshall((Object)webCrawlerConfiguration.getMaxUrlsPerMinuteCrawlRate(), MAXURLSPERMINUTECRAWLRATE_BINDING);
            protocolMarshaller.marshall(webCrawlerConfiguration.getUrlInclusionPatterns(), URLINCLUSIONPATTERNS_BINDING);
            protocolMarshaller.marshall(webCrawlerConfiguration.getUrlExclusionPatterns(), URLEXCLUSIONPATTERNS_BINDING);
            protocolMarshaller.marshall((Object)webCrawlerConfiguration.getProxyConfiguration(), PROXYCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)webCrawlerConfiguration.getAuthenticationConfiguration(), AUTHENTICATIONCONFIGURATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

