/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kendra.model.transform.ContentSourceConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ContentSourceConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> dataSourceIds;
    private List<String> faqIds;
    private Boolean directPutContent;

    public List<String> getDataSourceIds() {
        return this.dataSourceIds;
    }

    public void setDataSourceIds(Collection<String> dataSourceIds) {
        if (dataSourceIds == null) {
            this.dataSourceIds = null;
            return;
        }
        this.dataSourceIds = new ArrayList<String>(dataSourceIds);
    }

    public ContentSourceConfiguration withDataSourceIds(String ... dataSourceIds) {
        if (this.dataSourceIds == null) {
            this.setDataSourceIds(new ArrayList<String>(dataSourceIds.length));
        }
        for (String ele : dataSourceIds) {
            this.dataSourceIds.add(ele);
        }
        return this;
    }

    public ContentSourceConfiguration withDataSourceIds(Collection<String> dataSourceIds) {
        this.setDataSourceIds(dataSourceIds);
        return this;
    }

    public List<String> getFaqIds() {
        return this.faqIds;
    }

    public void setFaqIds(Collection<String> faqIds) {
        if (faqIds == null) {
            this.faqIds = null;
            return;
        }
        this.faqIds = new ArrayList<String>(faqIds);
    }

    public ContentSourceConfiguration withFaqIds(String ... faqIds) {
        if (this.faqIds == null) {
            this.setFaqIds(new ArrayList<String>(faqIds.length));
        }
        for (String ele : faqIds) {
            this.faqIds.add(ele);
        }
        return this;
    }

    public ContentSourceConfiguration withFaqIds(Collection<String> faqIds) {
        this.setFaqIds(faqIds);
        return this;
    }

    public void setDirectPutContent(Boolean directPutContent) {
        this.directPutContent = directPutContent;
    }

    public Boolean getDirectPutContent() {
        return this.directPutContent;
    }

    public ContentSourceConfiguration withDirectPutContent(Boolean directPutContent) {
        this.setDirectPutContent(directPutContent);
        return this;
    }

    public Boolean isDirectPutContent() {
        return this.directPutContent;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDataSourceIds() != null) {
            sb.append("DataSourceIds: ").append(this.getDataSourceIds()).append(",");
        }
        if (this.getFaqIds() != null) {
            sb.append("FaqIds: ").append(this.getFaqIds()).append(",");
        }
        if (this.getDirectPutContent() != null) {
            sb.append("DirectPutContent: ").append(this.getDirectPutContent());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContentSourceConfiguration)) {
            return false;
        }
        ContentSourceConfiguration other = (ContentSourceConfiguration)obj;
        if (other.getDataSourceIds() == null ^ this.getDataSourceIds() == null) {
            return false;
        }
        if (other.getDataSourceIds() != null && !other.getDataSourceIds().equals(this.getDataSourceIds())) {
            return false;
        }
        if (other.getFaqIds() == null ^ this.getFaqIds() == null) {
            return false;
        }
        if (other.getFaqIds() != null && !other.getFaqIds().equals(this.getFaqIds())) {
            return false;
        }
        if (other.getDirectPutContent() == null ^ this.getDirectPutContent() == null) {
            return false;
        }
        return other.getDirectPutContent() == null || other.getDirectPutContent().equals(this.getDirectPutContent());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDataSourceIds() == null ? 0 : this.getDataSourceIds().hashCode());
        hashCode = 31 * hashCode + (this.getFaqIds() == null ? 0 : this.getFaqIds().hashCode());
        hashCode = 31 * hashCode + (this.getDirectPutContent() == null ? 0 : this.getDirectPutContent().hashCode());
        return hashCode;
    }

    public ContentSourceConfiguration clone() {
        try {
            return (ContentSourceConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ContentSourceConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

