/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iottwinmaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iottwinmaker.model.DataConnector;
import com.amazonaws.services.iottwinmaker.model.Scope;
import com.amazonaws.services.iottwinmaker.model.transform.FunctionRequestMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FunctionRequest
implements Serializable,
Cloneable,
StructuredPojo {
    private DataConnector implementedBy;
    private List<String> requiredProperties;
    private String scope;

    public void setImplementedBy(DataConnector implementedBy) {
        this.implementedBy = implementedBy;
    }

    public DataConnector getImplementedBy() {
        return this.implementedBy;
    }

    public FunctionRequest withImplementedBy(DataConnector implementedBy) {
        this.setImplementedBy(implementedBy);
        return this;
    }

    public List<String> getRequiredProperties() {
        return this.requiredProperties;
    }

    public void setRequiredProperties(Collection<String> requiredProperties) {
        if (requiredProperties == null) {
            this.requiredProperties = null;
            return;
        }
        this.requiredProperties = new ArrayList<String>(requiredProperties);
    }

    public FunctionRequest withRequiredProperties(String ... requiredProperties) {
        if (this.requiredProperties == null) {
            this.setRequiredProperties(new ArrayList<String>(requiredProperties.length));
        }
        for (String ele : requiredProperties) {
            this.requiredProperties.add(ele);
        }
        return this;
    }

    public FunctionRequest withRequiredProperties(Collection<String> requiredProperties) {
        this.setRequiredProperties(requiredProperties);
        return this;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getScope() {
        return this.scope;
    }

    public FunctionRequest withScope(String scope) {
        this.setScope(scope);
        return this;
    }

    public FunctionRequest withScope(Scope scope) {
        this.scope = scope.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getImplementedBy() != null) {
            sb.append("ImplementedBy: ").append(this.getImplementedBy()).append(",");
        }
        if (this.getRequiredProperties() != null) {
            sb.append("RequiredProperties: ").append(this.getRequiredProperties()).append(",");
        }
        if (this.getScope() != null) {
            sb.append("Scope: ").append(this.getScope());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunctionRequest)) {
            return false;
        }
        FunctionRequest other = (FunctionRequest)obj;
        if (other.getImplementedBy() == null ^ this.getImplementedBy() == null) {
            return false;
        }
        if (other.getImplementedBy() != null && !other.getImplementedBy().equals(this.getImplementedBy())) {
            return false;
        }
        if (other.getRequiredProperties() == null ^ this.getRequiredProperties() == null) {
            return false;
        }
        if (other.getRequiredProperties() != null && !other.getRequiredProperties().equals(this.getRequiredProperties())) {
            return false;
        }
        if (other.getScope() == null ^ this.getScope() == null) {
            return false;
        }
        return other.getScope() == null || other.getScope().equals(this.getScope());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getImplementedBy() == null ? 0 : this.getImplementedBy().hashCode());
        hashCode = 31 * hashCode + (this.getRequiredProperties() == null ? 0 : this.getRequiredProperties().hashCode());
        hashCode = 31 * hashCode + (this.getScope() == null ? 0 : this.getScope().hashCode());
        return hashCode;
    }

    public FunctionRequest clone() {
        try {
            return (FunctionRequest)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FunctionRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

