/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotsecuretunneling.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotsecuretunneling.model.Tunnel;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class TunnelMarshaller {
    private static final MarshallingInfo<String> TUNNELID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tunnelId").build();
    private static final MarshallingInfo<String> TUNNELARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tunnelArn").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<StructuredPojo> SOURCECONNECTIONSTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sourceConnectionState").build();
    private static final MarshallingInfo<StructuredPojo> DESTINATIONCONNECTIONSTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("destinationConnectionState").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").build();
    private static final MarshallingInfo<StructuredPojo> DESTINATIONCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("destinationConfig").build();
    private static final MarshallingInfo<StructuredPojo> TIMEOUTCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timeoutConfig").build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").build();
    private static final MarshallingInfo<Date> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> LASTUPDATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUpdatedAt").timestampFormat("unixTimestamp").build();
    private static final TunnelMarshaller instance = new TunnelMarshaller();

    public static TunnelMarshaller getInstance() {
        return instance;
    }

    public void marshall(Tunnel tunnel, ProtocolMarshaller protocolMarshaller) {
        if (tunnel == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)tunnel.getTunnelId(), TUNNELID_BINDING);
            protocolMarshaller.marshall((Object)tunnel.getTunnelArn(), TUNNELARN_BINDING);
            protocolMarshaller.marshall((Object)tunnel.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)tunnel.getSourceConnectionState(), SOURCECONNECTIONSTATE_BINDING);
            protocolMarshaller.marshall((Object)tunnel.getDestinationConnectionState(), DESTINATIONCONNECTIONSTATE_BINDING);
            protocolMarshaller.marshall((Object)tunnel.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)tunnel.getDestinationConfig(), DESTINATIONCONFIG_BINDING);
            protocolMarshaller.marshall((Object)tunnel.getTimeoutConfig(), TIMEOUTCONFIG_BINDING);
            protocolMarshaller.marshall(tunnel.getTags(), TAGS_BINDING);
            protocolMarshaller.marshall((Object)tunnel.getCreatedAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)tunnel.getLastUpdatedAt(), LASTUPDATEDAT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

