/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.internetmonitor.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.internetmonitor.model.HealthEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListHealthEventsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<HealthEvent> healthEvents;
    private String nextToken;

    public List<HealthEvent> getHealthEvents() {
        return this.healthEvents;
    }

    public void setHealthEvents(Collection<HealthEvent> healthEvents) {
        if (healthEvents == null) {
            this.healthEvents = null;
            return;
        }
        this.healthEvents = new ArrayList<HealthEvent>(healthEvents);
    }

    public ListHealthEventsResult withHealthEvents(HealthEvent ... healthEvents) {
        if (this.healthEvents == null) {
            this.setHealthEvents(new ArrayList<HealthEvent>(healthEvents.length));
        }
        for (HealthEvent ele : healthEvents) {
            this.healthEvents.add(ele);
        }
        return this;
    }

    public ListHealthEventsResult withHealthEvents(Collection<HealthEvent> healthEvents) {
        this.setHealthEvents(healthEvents);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListHealthEventsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getHealthEvents() != null) {
            sb.append("HealthEvents: ").append(this.getHealthEvents()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHealthEventsResult)) {
            return false;
        }
        ListHealthEventsResult other = (ListHealthEventsResult)obj;
        if (other.getHealthEvents() == null ^ this.getHealthEvents() == null) {
            return false;
        }
        if (other.getHealthEvents() != null && !other.getHealthEvents().equals(this.getHealthEvents())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getHealthEvents() == null ? 0 : this.getHealthEvents().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListHealthEventsResult clone() {
        try {
            return (ListHealthEventsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

