/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.inspector.model.AssessmentRunFilter;
import com.amazonaws.services.inspector.model.transform.DurationRangeJsonMarshaller;
import com.amazonaws.services.inspector.model.transform.TimestampRangeJsonMarshaller;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.util.List;

public class AssessmentRunFilterJsonMarshaller {
    private static AssessmentRunFilterJsonMarshaller instance;

    public void marshall(AssessmentRunFilter assessmentRunFilter, StructuredJsonGenerator jsonGenerator) {
        if (assessmentRunFilter == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<String> rulesPackageArnsList;
            List<String> statesList;
            jsonGenerator.writeStartObject();
            if (assessmentRunFilter.getNamePattern() != null) {
                jsonGenerator.writeFieldName("namePattern").writeValue(assessmentRunFilter.getNamePattern());
            }
            if ((statesList = assessmentRunFilter.getStates()) != null) {
                jsonGenerator.writeFieldName("states");
                jsonGenerator.writeStartArray();
                for (String statesListValue : statesList) {
                    if (statesListValue == null) continue;
                    jsonGenerator.writeValue(statesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (assessmentRunFilter.getDurationRange() != null) {
                jsonGenerator.writeFieldName("durationRange");
                DurationRangeJsonMarshaller.getInstance().marshall(assessmentRunFilter.getDurationRange(), jsonGenerator);
            }
            if ((rulesPackageArnsList = assessmentRunFilter.getRulesPackageArns()) != null) {
                jsonGenerator.writeFieldName("rulesPackageArns");
                jsonGenerator.writeStartArray();
                for (String rulesPackageArnsListValue : rulesPackageArnsList) {
                    if (rulesPackageArnsListValue == null) continue;
                    jsonGenerator.writeValue(rulesPackageArnsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (assessmentRunFilter.getStartTimeRange() != null) {
                jsonGenerator.writeFieldName("startTimeRange");
                TimestampRangeJsonMarshaller.getInstance().marshall(assessmentRunFilter.getStartTimeRange(), jsonGenerator);
            }
            if (assessmentRunFilter.getCompletionTimeRange() != null) {
                jsonGenerator.writeFieldName("completionTimeRange");
                TimestampRangeJsonMarshaller.getInstance().marshall(assessmentRunFilter.getCompletionTimeRange(), jsonGenerator);
            }
            if (assessmentRunFilter.getStateChangeTimeRange() != null) {
                jsonGenerator.writeFieldName("stateChangeTimeRange");
                TimestampRangeJsonMarshaller.getInstance().marshall(assessmentRunFilter.getStateChangeTimeRange(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static AssessmentRunFilterJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new AssessmentRunFilterJsonMarshaller();
        }
        return instance;
    }
}

