/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model;

import com.amazonaws.services.inspector.model.EventSubscription;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Subscription
implements Serializable,
Cloneable {
    private String resourceArn;
    private String topicArn;
    private List<EventSubscription> eventSubscriptions;

    public void setResourceArn(String resourceArn) {
        this.resourceArn = resourceArn;
    }

    public String getResourceArn() {
        return this.resourceArn;
    }

    public Subscription withResourceArn(String resourceArn) {
        this.setResourceArn(resourceArn);
        return this;
    }

    public void setTopicArn(String topicArn) {
        this.topicArn = topicArn;
    }

    public String getTopicArn() {
        return this.topicArn;
    }

    public Subscription withTopicArn(String topicArn) {
        this.setTopicArn(topicArn);
        return this;
    }

    public List<EventSubscription> getEventSubscriptions() {
        return this.eventSubscriptions;
    }

    public void setEventSubscriptions(Collection<EventSubscription> eventSubscriptions) {
        if (eventSubscriptions == null) {
            this.eventSubscriptions = null;
            return;
        }
        this.eventSubscriptions = new ArrayList<EventSubscription>(eventSubscriptions);
    }

    public Subscription withEventSubscriptions(EventSubscription ... eventSubscriptions) {
        if (this.eventSubscriptions == null) {
            this.setEventSubscriptions(new ArrayList<EventSubscription>(eventSubscriptions.length));
        }
        for (EventSubscription ele : eventSubscriptions) {
            this.eventSubscriptions.add(ele);
        }
        return this;
    }

    public Subscription withEventSubscriptions(Collection<EventSubscription> eventSubscriptions) {
        this.setEventSubscriptions(eventSubscriptions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceArn() != null) {
            sb.append("ResourceArn: " + this.getResourceArn() + ",");
        }
        if (this.getTopicArn() != null) {
            sb.append("TopicArn: " + this.getTopicArn() + ",");
        }
        if (this.getEventSubscriptions() != null) {
            sb.append("EventSubscriptions: " + this.getEventSubscriptions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Subscription)) {
            return false;
        }
        Subscription other = (Subscription)obj;
        if (other.getResourceArn() == null ^ this.getResourceArn() == null) {
            return false;
        }
        if (other.getResourceArn() != null && !other.getResourceArn().equals(this.getResourceArn())) {
            return false;
        }
        if (other.getTopicArn() == null ^ this.getTopicArn() == null) {
            return false;
        }
        if (other.getTopicArn() != null && !other.getTopicArn().equals(this.getTopicArn())) {
            return false;
        }
        if (other.getEventSubscriptions() == null ^ this.getEventSubscriptions() == null) {
            return false;
        }
        return other.getEventSubscriptions() == null || other.getEventSubscriptions().equals(this.getEventSubscriptions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceArn() == null ? 0 : this.getResourceArn().hashCode());
        hashCode = 31 * hashCode + (this.getTopicArn() == null ? 0 : this.getTopicArn().hashCode());
        hashCode = 31 * hashCode + (this.getEventSubscriptions() == null ? 0 : this.getEventSubscriptions().hashCode());
        return hashCode;
    }

    public Subscription clone() {
        try {
            return (Subscription)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

