/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.imagebuilder.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.imagebuilder.model.ComponentConfiguration;
import com.amazonaws.services.imagebuilder.model.InstanceBlockDeviceMapping;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateImageRecipeRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private String description;
    private String semanticVersion;
    private List<ComponentConfiguration> components;
    private String parentImage;
    private List<InstanceBlockDeviceMapping> blockDeviceMappings;
    private Map<String, String> tags;
    private String workingDirectory;
    private String clientToken;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateImageRecipeRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateImageRecipeRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setSemanticVersion(String semanticVersion) {
        this.semanticVersion = semanticVersion;
    }

    public String getSemanticVersion() {
        return this.semanticVersion;
    }

    public CreateImageRecipeRequest withSemanticVersion(String semanticVersion) {
        this.setSemanticVersion(semanticVersion);
        return this;
    }

    public List<ComponentConfiguration> getComponents() {
        return this.components;
    }

    public void setComponents(Collection<ComponentConfiguration> components) {
        if (components == null) {
            this.components = null;
            return;
        }
        this.components = new ArrayList<ComponentConfiguration>(components);
    }

    public CreateImageRecipeRequest withComponents(ComponentConfiguration ... components) {
        if (this.components == null) {
            this.setComponents(new ArrayList<ComponentConfiguration>(components.length));
        }
        for (ComponentConfiguration ele : components) {
            this.components.add(ele);
        }
        return this;
    }

    public CreateImageRecipeRequest withComponents(Collection<ComponentConfiguration> components) {
        this.setComponents(components);
        return this;
    }

    public void setParentImage(String parentImage) {
        this.parentImage = parentImage;
    }

    public String getParentImage() {
        return this.parentImage;
    }

    public CreateImageRecipeRequest withParentImage(String parentImage) {
        this.setParentImage(parentImage);
        return this;
    }

    public List<InstanceBlockDeviceMapping> getBlockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public void setBlockDeviceMappings(Collection<InstanceBlockDeviceMapping> blockDeviceMappings) {
        if (blockDeviceMappings == null) {
            this.blockDeviceMappings = null;
            return;
        }
        this.blockDeviceMappings = new ArrayList<InstanceBlockDeviceMapping>(blockDeviceMappings);
    }

    public CreateImageRecipeRequest withBlockDeviceMappings(InstanceBlockDeviceMapping ... blockDeviceMappings) {
        if (this.blockDeviceMappings == null) {
            this.setBlockDeviceMappings(new ArrayList<InstanceBlockDeviceMapping>(blockDeviceMappings.length));
        }
        for (InstanceBlockDeviceMapping ele : blockDeviceMappings) {
            this.blockDeviceMappings.add(ele);
        }
        return this;
    }

    public CreateImageRecipeRequest withBlockDeviceMappings(Collection<InstanceBlockDeviceMapping> blockDeviceMappings) {
        this.setBlockDeviceMappings(blockDeviceMappings);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateImageRecipeRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateImageRecipeRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateImageRecipeRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public CreateImageRecipeRequest withWorkingDirectory(String workingDirectory) {
        this.setWorkingDirectory(workingDirectory);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateImageRecipeRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getSemanticVersion() != null) {
            sb.append("SemanticVersion: ").append(this.getSemanticVersion()).append(",");
        }
        if (this.getComponents() != null) {
            sb.append("Components: ").append(this.getComponents()).append(",");
        }
        if (this.getParentImage() != null) {
            sb.append("ParentImage: ").append(this.getParentImage()).append(",");
        }
        if (this.getBlockDeviceMappings() != null) {
            sb.append("BlockDeviceMappings: ").append(this.getBlockDeviceMappings()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getWorkingDirectory() != null) {
            sb.append("WorkingDirectory: ").append(this.getWorkingDirectory()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateImageRecipeRequest)) {
            return false;
        }
        CreateImageRecipeRequest other = (CreateImageRecipeRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getSemanticVersion() == null ^ this.getSemanticVersion() == null) {
            return false;
        }
        if (other.getSemanticVersion() != null && !other.getSemanticVersion().equals(this.getSemanticVersion())) {
            return false;
        }
        if (other.getComponents() == null ^ this.getComponents() == null) {
            return false;
        }
        if (other.getComponents() != null && !other.getComponents().equals(this.getComponents())) {
            return false;
        }
        if (other.getParentImage() == null ^ this.getParentImage() == null) {
            return false;
        }
        if (other.getParentImage() != null && !other.getParentImage().equals(this.getParentImage())) {
            return false;
        }
        if (other.getBlockDeviceMappings() == null ^ this.getBlockDeviceMappings() == null) {
            return false;
        }
        if (other.getBlockDeviceMappings() != null && !other.getBlockDeviceMappings().equals(this.getBlockDeviceMappings())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getWorkingDirectory() == null ^ this.getWorkingDirectory() == null) {
            return false;
        }
        if (other.getWorkingDirectory() != null && !other.getWorkingDirectory().equals(this.getWorkingDirectory())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        return other.getClientToken() == null || other.getClientToken().equals(this.getClientToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getSemanticVersion() == null ? 0 : this.getSemanticVersion().hashCode());
        hashCode = 31 * hashCode + (this.getComponents() == null ? 0 : this.getComponents().hashCode());
        hashCode = 31 * hashCode + (this.getParentImage() == null ? 0 : this.getParentImage().hashCode());
        hashCode = 31 * hashCode + (this.getBlockDeviceMappings() == null ? 0 : this.getBlockDeviceMappings().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getWorkingDirectory() == null ? 0 : this.getWorkingDirectory().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        return hashCode;
    }

    public CreateImageRecipeRequest clone() {
        return (CreateImageRecipeRequest)super.clone();
    }
}

