/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glue.model.GlueSchema;
import com.amazonaws.services.glue.model.SqlAlias;
import com.amazonaws.services.glue.model.transform.SparkSQLMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SparkSQL
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private List<String> inputs;
    private String sqlQuery;
    private List<SqlAlias> sqlAliases;
    private List<GlueSchema> outputSchemas;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public SparkSQL withName(String name) {
        this.setName(name);
        return this;
    }

    public List<String> getInputs() {
        return this.inputs;
    }

    public void setInputs(Collection<String> inputs) {
        if (inputs == null) {
            this.inputs = null;
            return;
        }
        this.inputs = new ArrayList<String>(inputs);
    }

    public SparkSQL withInputs(String ... inputs) {
        if (this.inputs == null) {
            this.setInputs(new ArrayList<String>(inputs.length));
        }
        for (String ele : inputs) {
            this.inputs.add(ele);
        }
        return this;
    }

    public SparkSQL withInputs(Collection<String> inputs) {
        this.setInputs(inputs);
        return this;
    }

    public void setSqlQuery(String sqlQuery) {
        this.sqlQuery = sqlQuery;
    }

    public String getSqlQuery() {
        return this.sqlQuery;
    }

    public SparkSQL withSqlQuery(String sqlQuery) {
        this.setSqlQuery(sqlQuery);
        return this;
    }

    public List<SqlAlias> getSqlAliases() {
        return this.sqlAliases;
    }

    public void setSqlAliases(Collection<SqlAlias> sqlAliases) {
        if (sqlAliases == null) {
            this.sqlAliases = null;
            return;
        }
        this.sqlAliases = new ArrayList<SqlAlias>(sqlAliases);
    }

    public SparkSQL withSqlAliases(SqlAlias ... sqlAliases) {
        if (this.sqlAliases == null) {
            this.setSqlAliases(new ArrayList<SqlAlias>(sqlAliases.length));
        }
        for (SqlAlias ele : sqlAliases) {
            this.sqlAliases.add(ele);
        }
        return this;
    }

    public SparkSQL withSqlAliases(Collection<SqlAlias> sqlAliases) {
        this.setSqlAliases(sqlAliases);
        return this;
    }

    public List<GlueSchema> getOutputSchemas() {
        return this.outputSchemas;
    }

    public void setOutputSchemas(Collection<GlueSchema> outputSchemas) {
        if (outputSchemas == null) {
            this.outputSchemas = null;
            return;
        }
        this.outputSchemas = new ArrayList<GlueSchema>(outputSchemas);
    }

    public SparkSQL withOutputSchemas(GlueSchema ... outputSchemas) {
        if (this.outputSchemas == null) {
            this.setOutputSchemas(new ArrayList<GlueSchema>(outputSchemas.length));
        }
        for (GlueSchema ele : outputSchemas) {
            this.outputSchemas.add(ele);
        }
        return this;
    }

    public SparkSQL withOutputSchemas(Collection<GlueSchema> outputSchemas) {
        this.setOutputSchemas(outputSchemas);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getInputs() != null) {
            sb.append("Inputs: ").append(this.getInputs()).append(",");
        }
        if (this.getSqlQuery() != null) {
            sb.append("SqlQuery: ").append(this.getSqlQuery()).append(",");
        }
        if (this.getSqlAliases() != null) {
            sb.append("SqlAliases: ").append(this.getSqlAliases()).append(",");
        }
        if (this.getOutputSchemas() != null) {
            sb.append("OutputSchemas: ").append(this.getOutputSchemas());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SparkSQL)) {
            return false;
        }
        SparkSQL other = (SparkSQL)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getInputs() == null ^ this.getInputs() == null) {
            return false;
        }
        if (other.getInputs() != null && !other.getInputs().equals(this.getInputs())) {
            return false;
        }
        if (other.getSqlQuery() == null ^ this.getSqlQuery() == null) {
            return false;
        }
        if (other.getSqlQuery() != null && !other.getSqlQuery().equals(this.getSqlQuery())) {
            return false;
        }
        if (other.getSqlAliases() == null ^ this.getSqlAliases() == null) {
            return false;
        }
        if (other.getSqlAliases() != null && !other.getSqlAliases().equals(this.getSqlAliases())) {
            return false;
        }
        if (other.getOutputSchemas() == null ^ this.getOutputSchemas() == null) {
            return false;
        }
        return other.getOutputSchemas() == null || other.getOutputSchemas().equals(this.getOutputSchemas());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getInputs() == null ? 0 : this.getInputs().hashCode());
        hashCode = 31 * hashCode + (this.getSqlQuery() == null ? 0 : this.getSqlQuery().hashCode());
        hashCode = 31 * hashCode + (this.getSqlAliases() == null ? 0 : this.getSqlAliases().hashCode());
        hashCode = 31 * hashCode + (this.getOutputSchemas() == null ? 0 : this.getOutputSchemas().hashCode());
        return hashCode;
    }

    public SparkSQL clone() {
        try {
            return (SparkSQL)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SparkSQLMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

