/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.globalaccelerator.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.globalaccelerator.model.CustomRoutingDestinationTrafficState;
import com.amazonaws.services.globalaccelerator.model.IpAddressType;
import com.amazonaws.services.globalaccelerator.model.SocketAddress;
import com.amazonaws.services.globalaccelerator.model.transform.DestinationPortMappingMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DestinationPortMapping
implements Serializable,
Cloneable,
StructuredPojo {
    private String acceleratorArn;
    private List<SocketAddress> acceleratorSocketAddresses;
    private String endpointGroupArn;
    private String endpointId;
    private String endpointGroupRegion;
    private SocketAddress destinationSocketAddress;
    private String ipAddressType;
    private String destinationTrafficState;

    public void setAcceleratorArn(String acceleratorArn) {
        this.acceleratorArn = acceleratorArn;
    }

    public String getAcceleratorArn() {
        return this.acceleratorArn;
    }

    public DestinationPortMapping withAcceleratorArn(String acceleratorArn) {
        this.setAcceleratorArn(acceleratorArn);
        return this;
    }

    public List<SocketAddress> getAcceleratorSocketAddresses() {
        return this.acceleratorSocketAddresses;
    }

    public void setAcceleratorSocketAddresses(Collection<SocketAddress> acceleratorSocketAddresses) {
        if (acceleratorSocketAddresses == null) {
            this.acceleratorSocketAddresses = null;
            return;
        }
        this.acceleratorSocketAddresses = new ArrayList<SocketAddress>(acceleratorSocketAddresses);
    }

    public DestinationPortMapping withAcceleratorSocketAddresses(SocketAddress ... acceleratorSocketAddresses) {
        if (this.acceleratorSocketAddresses == null) {
            this.setAcceleratorSocketAddresses(new ArrayList<SocketAddress>(acceleratorSocketAddresses.length));
        }
        for (SocketAddress ele : acceleratorSocketAddresses) {
            this.acceleratorSocketAddresses.add(ele);
        }
        return this;
    }

    public DestinationPortMapping withAcceleratorSocketAddresses(Collection<SocketAddress> acceleratorSocketAddresses) {
        this.setAcceleratorSocketAddresses(acceleratorSocketAddresses);
        return this;
    }

    public void setEndpointGroupArn(String endpointGroupArn) {
        this.endpointGroupArn = endpointGroupArn;
    }

    public String getEndpointGroupArn() {
        return this.endpointGroupArn;
    }

    public DestinationPortMapping withEndpointGroupArn(String endpointGroupArn) {
        this.setEndpointGroupArn(endpointGroupArn);
        return this;
    }

    public void setEndpointId(String endpointId) {
        this.endpointId = endpointId;
    }

    public String getEndpointId() {
        return this.endpointId;
    }

    public DestinationPortMapping withEndpointId(String endpointId) {
        this.setEndpointId(endpointId);
        return this;
    }

    public void setEndpointGroupRegion(String endpointGroupRegion) {
        this.endpointGroupRegion = endpointGroupRegion;
    }

    public String getEndpointGroupRegion() {
        return this.endpointGroupRegion;
    }

    public DestinationPortMapping withEndpointGroupRegion(String endpointGroupRegion) {
        this.setEndpointGroupRegion(endpointGroupRegion);
        return this;
    }

    public void setDestinationSocketAddress(SocketAddress destinationSocketAddress) {
        this.destinationSocketAddress = destinationSocketAddress;
    }

    public SocketAddress getDestinationSocketAddress() {
        return this.destinationSocketAddress;
    }

    public DestinationPortMapping withDestinationSocketAddress(SocketAddress destinationSocketAddress) {
        this.setDestinationSocketAddress(destinationSocketAddress);
        return this;
    }

    public void setIpAddressType(String ipAddressType) {
        this.ipAddressType = ipAddressType;
    }

    public String getIpAddressType() {
        return this.ipAddressType;
    }

    public DestinationPortMapping withIpAddressType(String ipAddressType) {
        this.setIpAddressType(ipAddressType);
        return this;
    }

    public DestinationPortMapping withIpAddressType(IpAddressType ipAddressType) {
        this.ipAddressType = ipAddressType.toString();
        return this;
    }

    public void setDestinationTrafficState(String destinationTrafficState) {
        this.destinationTrafficState = destinationTrafficState;
    }

    public String getDestinationTrafficState() {
        return this.destinationTrafficState;
    }

    public DestinationPortMapping withDestinationTrafficState(String destinationTrafficState) {
        this.setDestinationTrafficState(destinationTrafficState);
        return this;
    }

    public DestinationPortMapping withDestinationTrafficState(CustomRoutingDestinationTrafficState destinationTrafficState) {
        this.destinationTrafficState = destinationTrafficState.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAcceleratorArn() != null) {
            sb.append("AcceleratorArn: ").append(this.getAcceleratorArn()).append(",");
        }
        if (this.getAcceleratorSocketAddresses() != null) {
            sb.append("AcceleratorSocketAddresses: ").append(this.getAcceleratorSocketAddresses()).append(",");
        }
        if (this.getEndpointGroupArn() != null) {
            sb.append("EndpointGroupArn: ").append(this.getEndpointGroupArn()).append(",");
        }
        if (this.getEndpointId() != null) {
            sb.append("EndpointId: ").append(this.getEndpointId()).append(",");
        }
        if (this.getEndpointGroupRegion() != null) {
            sb.append("EndpointGroupRegion: ").append(this.getEndpointGroupRegion()).append(",");
        }
        if (this.getDestinationSocketAddress() != null) {
            sb.append("DestinationSocketAddress: ").append(this.getDestinationSocketAddress()).append(",");
        }
        if (this.getIpAddressType() != null) {
            sb.append("IpAddressType: ").append(this.getIpAddressType()).append(",");
        }
        if (this.getDestinationTrafficState() != null) {
            sb.append("DestinationTrafficState: ").append(this.getDestinationTrafficState());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DestinationPortMapping)) {
            return false;
        }
        DestinationPortMapping other = (DestinationPortMapping)obj;
        if (other.getAcceleratorArn() == null ^ this.getAcceleratorArn() == null) {
            return false;
        }
        if (other.getAcceleratorArn() != null && !other.getAcceleratorArn().equals(this.getAcceleratorArn())) {
            return false;
        }
        if (other.getAcceleratorSocketAddresses() == null ^ this.getAcceleratorSocketAddresses() == null) {
            return false;
        }
        if (other.getAcceleratorSocketAddresses() != null && !other.getAcceleratorSocketAddresses().equals(this.getAcceleratorSocketAddresses())) {
            return false;
        }
        if (other.getEndpointGroupArn() == null ^ this.getEndpointGroupArn() == null) {
            return false;
        }
        if (other.getEndpointGroupArn() != null && !other.getEndpointGroupArn().equals(this.getEndpointGroupArn())) {
            return false;
        }
        if (other.getEndpointId() == null ^ this.getEndpointId() == null) {
            return false;
        }
        if (other.getEndpointId() != null && !other.getEndpointId().equals(this.getEndpointId())) {
            return false;
        }
        if (other.getEndpointGroupRegion() == null ^ this.getEndpointGroupRegion() == null) {
            return false;
        }
        if (other.getEndpointGroupRegion() != null && !other.getEndpointGroupRegion().equals(this.getEndpointGroupRegion())) {
            return false;
        }
        if (other.getDestinationSocketAddress() == null ^ this.getDestinationSocketAddress() == null) {
            return false;
        }
        if (other.getDestinationSocketAddress() != null && !other.getDestinationSocketAddress().equals(this.getDestinationSocketAddress())) {
            return false;
        }
        if (other.getIpAddressType() == null ^ this.getIpAddressType() == null) {
            return false;
        }
        if (other.getIpAddressType() != null && !other.getIpAddressType().equals(this.getIpAddressType())) {
            return false;
        }
        if (other.getDestinationTrafficState() == null ^ this.getDestinationTrafficState() == null) {
            return false;
        }
        return other.getDestinationTrafficState() == null || other.getDestinationTrafficState().equals(this.getDestinationTrafficState());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAcceleratorArn() == null ? 0 : this.getAcceleratorArn().hashCode());
        hashCode = 31 * hashCode + (this.getAcceleratorSocketAddresses() == null ? 0 : this.getAcceleratorSocketAddresses().hashCode());
        hashCode = 31 * hashCode + (this.getEndpointGroupArn() == null ? 0 : this.getEndpointGroupArn().hashCode());
        hashCode = 31 * hashCode + (this.getEndpointId() == null ? 0 : this.getEndpointId().hashCode());
        hashCode = 31 * hashCode + (this.getEndpointGroupRegion() == null ? 0 : this.getEndpointGroupRegion().hashCode());
        hashCode = 31 * hashCode + (this.getDestinationSocketAddress() == null ? 0 : this.getDestinationSocketAddress().hashCode());
        hashCode = 31 * hashCode + (this.getIpAddressType() == null ? 0 : this.getIpAddressType().hashCode());
        hashCode = 31 * hashCode + (this.getDestinationTrafficState() == null ? 0 : this.getDestinationTrafficState().hashCode());
        return hashCode;
    }

    public DestinationPortMapping clone() {
        try {
            return (DestinationPortMapping)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DestinationPortMappingMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

