/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.globalaccelerator.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.globalaccelerator.model.CustomRoutingProtocol;
import com.amazonaws.services.globalaccelerator.model.transform.CustomRoutingDestinationConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CustomRoutingDestinationConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer fromPort;
    private Integer toPort;
    private List<String> protocols;

    public void setFromPort(Integer fromPort) {
        this.fromPort = fromPort;
    }

    public Integer getFromPort() {
        return this.fromPort;
    }

    public CustomRoutingDestinationConfiguration withFromPort(Integer fromPort) {
        this.setFromPort(fromPort);
        return this;
    }

    public void setToPort(Integer toPort) {
        this.toPort = toPort;
    }

    public Integer getToPort() {
        return this.toPort;
    }

    public CustomRoutingDestinationConfiguration withToPort(Integer toPort) {
        this.setToPort(toPort);
        return this;
    }

    public List<String> getProtocols() {
        return this.protocols;
    }

    public void setProtocols(Collection<String> protocols) {
        if (protocols == null) {
            this.protocols = null;
            return;
        }
        this.protocols = new ArrayList<String>(protocols);
    }

    public CustomRoutingDestinationConfiguration withProtocols(String ... protocols) {
        if (this.protocols == null) {
            this.setProtocols(new ArrayList<String>(protocols.length));
        }
        for (String ele : protocols) {
            this.protocols.add(ele);
        }
        return this;
    }

    public CustomRoutingDestinationConfiguration withProtocols(Collection<String> protocols) {
        this.setProtocols(protocols);
        return this;
    }

    public CustomRoutingDestinationConfiguration withProtocols(CustomRoutingProtocol ... protocols) {
        ArrayList<String> protocolsCopy = new ArrayList<String>(protocols.length);
        for (CustomRoutingProtocol value : protocols) {
            protocolsCopy.add(value.toString());
        }
        if (this.getProtocols() == null) {
            this.setProtocols(protocolsCopy);
        } else {
            this.getProtocols().addAll(protocolsCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFromPort() != null) {
            sb.append("FromPort: ").append(this.getFromPort()).append(",");
        }
        if (this.getToPort() != null) {
            sb.append("ToPort: ").append(this.getToPort()).append(",");
        }
        if (this.getProtocols() != null) {
            sb.append("Protocols: ").append(this.getProtocols());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomRoutingDestinationConfiguration)) {
            return false;
        }
        CustomRoutingDestinationConfiguration other = (CustomRoutingDestinationConfiguration)obj;
        if (other.getFromPort() == null ^ this.getFromPort() == null) {
            return false;
        }
        if (other.getFromPort() != null && !other.getFromPort().equals(this.getFromPort())) {
            return false;
        }
        if (other.getToPort() == null ^ this.getToPort() == null) {
            return false;
        }
        if (other.getToPort() != null && !other.getToPort().equals(this.getToPort())) {
            return false;
        }
        if (other.getProtocols() == null ^ this.getProtocols() == null) {
            return false;
        }
        return other.getProtocols() == null || other.getProtocols().equals(this.getProtocols());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFromPort() == null ? 0 : this.getFromPort().hashCode());
        hashCode = 31 * hashCode + (this.getToPort() == null ? 0 : this.getToPort().hashCode());
        hashCode = 31 * hashCode + (this.getProtocols() == null ? 0 : this.getProtocols().hashCode());
        return hashCode;
    }

    public CustomRoutingDestinationConfiguration clone() {
        try {
            return (CustomRoutingDestinationConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CustomRoutingDestinationConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

