/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamesparks.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.gamesparks.model.SectionModification;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateGameConfigurationRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String gameName;
    private List<SectionModification> modifications;

    public void setGameName(String gameName) {
        this.gameName = gameName;
    }

    public String getGameName() {
        return this.gameName;
    }

    public UpdateGameConfigurationRequest withGameName(String gameName) {
        this.setGameName(gameName);
        return this;
    }

    public List<SectionModification> getModifications() {
        return this.modifications;
    }

    public void setModifications(Collection<SectionModification> modifications) {
        if (modifications == null) {
            this.modifications = null;
            return;
        }
        this.modifications = new ArrayList<SectionModification>(modifications);
    }

    public UpdateGameConfigurationRequest withModifications(SectionModification ... modifications) {
        if (this.modifications == null) {
            this.setModifications(new ArrayList<SectionModification>(modifications.length));
        }
        for (SectionModification ele : modifications) {
            this.modifications.add(ele);
        }
        return this;
    }

    public UpdateGameConfigurationRequest withModifications(Collection<SectionModification> modifications) {
        this.setModifications(modifications);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGameName() != null) {
            sb.append("GameName: ").append(this.getGameName()).append(",");
        }
        if (this.getModifications() != null) {
            sb.append("Modifications: ").append(this.getModifications());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGameConfigurationRequest)) {
            return false;
        }
        UpdateGameConfigurationRequest other = (UpdateGameConfigurationRequest)obj;
        if (other.getGameName() == null ^ this.getGameName() == null) {
            return false;
        }
        if (other.getGameName() != null && !other.getGameName().equals(this.getGameName())) {
            return false;
        }
        if (other.getModifications() == null ^ this.getModifications() == null) {
            return false;
        }
        return other.getModifications() == null || other.getModifications().equals(this.getModifications());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGameName() == null ? 0 : this.getGameName().hashCode());
        hashCode = 31 * hashCode + (this.getModifications() == null ? 0 : this.getModifications().hashCode());
        return hashCode;
    }

    public UpdateGameConfigurationRequest clone() {
        return (UpdateGameConfigurationRequest)super.clone();
    }
}

