/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.gamesparks.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/GetExtensionVersion" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GetExtensionVersionResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * The version of the extension.
     * </p>
     */
    private ExtensionVersionDetails extensionVersion;

    /**
     * <p>
     * The version of the extension.
     * </p>
     * 
     * @param extensionVersion
     *        The version of the extension.
     */

    public void setExtensionVersion(ExtensionVersionDetails extensionVersion) {
        this.extensionVersion = extensionVersion;
    }

    /**
     * <p>
     * The version of the extension.
     * </p>
     * 
     * @return The version of the extension.
     */

    public ExtensionVersionDetails getExtensionVersion() {
        return this.extensionVersion;
    }

    /**
     * <p>
     * The version of the extension.
     * </p>
     * 
     * @param extensionVersion
     *        The version of the extension.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetExtensionVersionResult withExtensionVersion(ExtensionVersionDetails extensionVersion) {
        setExtensionVersion(extensionVersion);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getExtensionVersion() != null)
            sb.append("ExtensionVersion: ").append(getExtensionVersion());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof GetExtensionVersionResult == false)
            return false;
        GetExtensionVersionResult other = (GetExtensionVersionResult) obj;
        if (other.getExtensionVersion() == null ^ this.getExtensionVersion() == null)
            return false;
        if (other.getExtensionVersion() != null && other.getExtensionVersion().equals(this.getExtensionVersion()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getExtensionVersion() == null) ? 0 : getExtensionVersion().hashCode());
        return hashCode;
    }

    @Override
    public GetExtensionVersionResult clone() {
        try {
            return (GetExtensionVersionResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
