/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.gamelift.model.AttributeValue;
import com.amazonaws.services.gamelift.model.transform.PlayerMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Player
implements Serializable,
Cloneable,
StructuredPojo {
    private String playerId;
    private Map<String, AttributeValue> playerAttributes;
    private String team;
    private Map<String, Integer> latencyInMs;

    public void setPlayerId(String playerId) {
        this.playerId = playerId;
    }

    public String getPlayerId() {
        return this.playerId;
    }

    public Player withPlayerId(String playerId) {
        this.setPlayerId(playerId);
        return this;
    }

    public Map<String, AttributeValue> getPlayerAttributes() {
        return this.playerAttributes;
    }

    public void setPlayerAttributes(Map<String, AttributeValue> playerAttributes) {
        this.playerAttributes = playerAttributes;
    }

    public Player withPlayerAttributes(Map<String, AttributeValue> playerAttributes) {
        this.setPlayerAttributes(playerAttributes);
        return this;
    }

    public Player addPlayerAttributesEntry(String key, AttributeValue value) {
        if (null == this.playerAttributes) {
            this.playerAttributes = new HashMap<String, AttributeValue>();
        }
        if (this.playerAttributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.playerAttributes.put(key, value);
        return this;
    }

    public Player clearPlayerAttributesEntries() {
        this.playerAttributes = null;
        return this;
    }

    public void setTeam(String team) {
        this.team = team;
    }

    public String getTeam() {
        return this.team;
    }

    public Player withTeam(String team) {
        this.setTeam(team);
        return this;
    }

    public Map<String, Integer> getLatencyInMs() {
        return this.latencyInMs;
    }

    public void setLatencyInMs(Map<String, Integer> latencyInMs) {
        this.latencyInMs = latencyInMs;
    }

    public Player withLatencyInMs(Map<String, Integer> latencyInMs) {
        this.setLatencyInMs(latencyInMs);
        return this;
    }

    public Player addLatencyInMsEntry(String key, Integer value) {
        if (null == this.latencyInMs) {
            this.latencyInMs = new HashMap<String, Integer>();
        }
        if (this.latencyInMs.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.latencyInMs.put(key, value);
        return this;
    }

    public Player clearLatencyInMsEntries() {
        this.latencyInMs = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPlayerId() != null) {
            sb.append("PlayerId: ").append(this.getPlayerId()).append(",");
        }
        if (this.getPlayerAttributes() != null) {
            sb.append("PlayerAttributes: ").append(this.getPlayerAttributes()).append(",");
        }
        if (this.getTeam() != null) {
            sb.append("Team: ").append(this.getTeam()).append(",");
        }
        if (this.getLatencyInMs() != null) {
            sb.append("LatencyInMs: ").append(this.getLatencyInMs());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Player)) {
            return false;
        }
        Player other = (Player)obj;
        if (other.getPlayerId() == null ^ this.getPlayerId() == null) {
            return false;
        }
        if (other.getPlayerId() != null && !other.getPlayerId().equals(this.getPlayerId())) {
            return false;
        }
        if (other.getPlayerAttributes() == null ^ this.getPlayerAttributes() == null) {
            return false;
        }
        if (other.getPlayerAttributes() != null && !other.getPlayerAttributes().equals(this.getPlayerAttributes())) {
            return false;
        }
        if (other.getTeam() == null ^ this.getTeam() == null) {
            return false;
        }
        if (other.getTeam() != null && !other.getTeam().equals(this.getTeam())) {
            return false;
        }
        if (other.getLatencyInMs() == null ^ this.getLatencyInMs() == null) {
            return false;
        }
        return other.getLatencyInMs() == null || other.getLatencyInMs().equals(this.getLatencyInMs());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPlayerId() == null ? 0 : this.getPlayerId().hashCode());
        hashCode = 31 * hashCode + (this.getPlayerAttributes() == null ? 0 : this.getPlayerAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getTeam() == null ? 0 : this.getTeam().hashCode());
        hashCode = 31 * hashCode + (this.getLatencyInMs() == null ? 0 : this.getLatencyInMs().hashCode());
        return hashCode;
    }

    public Player clone() {
        try {
            return (Player)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PlayerMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

