/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.gamelift.model.S3Location;
import com.amazonaws.services.gamelift.model.Tag;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateScriptRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private String version;
    private S3Location storageLocation;
    private ByteBuffer zipFile;
    private List<Tag> tags;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateScriptRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public CreateScriptRequest withVersion(String version) {
        this.setVersion(version);
        return this;
    }

    public void setStorageLocation(S3Location storageLocation) {
        this.storageLocation = storageLocation;
    }

    public S3Location getStorageLocation() {
        return this.storageLocation;
    }

    public CreateScriptRequest withStorageLocation(S3Location storageLocation) {
        this.setStorageLocation(storageLocation);
        return this;
    }

    public void setZipFile(ByteBuffer zipFile) {
        this.zipFile = zipFile;
    }

    public ByteBuffer getZipFile() {
        return this.zipFile;
    }

    public CreateScriptRequest withZipFile(ByteBuffer zipFile) {
        this.setZipFile(zipFile);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateScriptRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateScriptRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getVersion() != null) {
            sb.append("Version: ").append(this.getVersion()).append(",");
        }
        if (this.getStorageLocation() != null) {
            sb.append("StorageLocation: ").append(this.getStorageLocation()).append(",");
        }
        if (this.getZipFile() != null) {
            sb.append("ZipFile: ").append(this.getZipFile()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateScriptRequest)) {
            return false;
        }
        CreateScriptRequest other = (CreateScriptRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getVersion() == null ^ this.getVersion() == null) {
            return false;
        }
        if (other.getVersion() != null && !other.getVersion().equals(this.getVersion())) {
            return false;
        }
        if (other.getStorageLocation() == null ^ this.getStorageLocation() == null) {
            return false;
        }
        if (other.getStorageLocation() != null && !other.getStorageLocation().equals(this.getStorageLocation())) {
            return false;
        }
        if (other.getZipFile() == null ^ this.getZipFile() == null) {
            return false;
        }
        if (other.getZipFile() != null && !other.getZipFile().equals(this.getZipFile())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getVersion() == null ? 0 : this.getVersion().hashCode());
        hashCode = 31 * hashCode + (this.getStorageLocation() == null ? 0 : this.getStorageLocation().hashCode());
        hashCode = 31 * hashCode + (this.getZipFile() == null ? 0 : this.getZipFile().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateScriptRequest clone() {
        return (CreateScriptRequest)super.clone();
    }
}

