/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fsx.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.fsx.model.DataRepositoryAssociation;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class DataRepositoryAssociationMarshaller {
    private static final MarshallingInfo<String> ASSOCIATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssociationId").build();
    private static final MarshallingInfo<String> RESOURCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceARN").build();
    private static final MarshallingInfo<String> FILESYSTEMID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FileSystemId").build();
    private static final MarshallingInfo<String> LIFECYCLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Lifecycle").build();
    private static final MarshallingInfo<StructuredPojo> FAILUREDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FailureDetails").build();
    private static final MarshallingInfo<String> FILESYSTEMPATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FileSystemPath").build();
    private static final MarshallingInfo<String> DATAREPOSITORYPATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataRepositoryPath").build();
    private static final MarshallingInfo<Boolean> BATCHIMPORTMETADATAONCREATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BatchImportMetaDataOnCreate").build();
    private static final MarshallingInfo<Integer> IMPORTEDFILECHUNKSIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ImportedFileChunkSize").build();
    private static final MarshallingInfo<StructuredPojo> S3_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3").build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").build();
    private static final MarshallingInfo<Date> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").timestampFormat("unixTimestamp").build();
    private static final DataRepositoryAssociationMarshaller instance = new DataRepositoryAssociationMarshaller();

    public static DataRepositoryAssociationMarshaller getInstance() {
        return instance;
    }

    public void marshall(DataRepositoryAssociation dataRepositoryAssociation, ProtocolMarshaller protocolMarshaller) {
        if (dataRepositoryAssociation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)dataRepositoryAssociation.getAssociationId(), ASSOCIATIONID_BINDING);
            protocolMarshaller.marshall((Object)dataRepositoryAssociation.getResourceARN(), RESOURCEARN_BINDING);
            protocolMarshaller.marshall((Object)dataRepositoryAssociation.getFileSystemId(), FILESYSTEMID_BINDING);
            protocolMarshaller.marshall((Object)dataRepositoryAssociation.getLifecycle(), LIFECYCLE_BINDING);
            protocolMarshaller.marshall((Object)dataRepositoryAssociation.getFailureDetails(), FAILUREDETAILS_BINDING);
            protocolMarshaller.marshall((Object)dataRepositoryAssociation.getFileSystemPath(), FILESYSTEMPATH_BINDING);
            protocolMarshaller.marshall((Object)dataRepositoryAssociation.getDataRepositoryPath(), DATAREPOSITORYPATH_BINDING);
            protocolMarshaller.marshall((Object)dataRepositoryAssociation.getBatchImportMetaDataOnCreate(), BATCHIMPORTMETADATAONCREATE_BINDING);
            protocolMarshaller.marshall((Object)dataRepositoryAssociation.getImportedFileChunkSize(), IMPORTEDFILECHUNKSIZE_BINDING);
            protocolMarshaller.marshall((Object)dataRepositoryAssociation.getS3(), S3_BINDING);
            protocolMarshaller.marshall(dataRepositoryAssociation.getTags(), TAGS_BINDING);
            protocolMarshaller.marshall((Object)dataRepositoryAssociation.getCreationTime(), CREATIONTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

