/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eventbridge.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.eventbridge.model.HttpParameters;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class HttpParametersMarshaller {
    private static final MarshallingInfo<List> PATHPARAMETERVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PathParameterValues").build();
    private static final MarshallingInfo<Map> HEADERPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HeaderParameters").build();
    private static final MarshallingInfo<Map> QUERYSTRINGPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("QueryStringParameters").build();
    private static final HttpParametersMarshaller instance = new HttpParametersMarshaller();

    public static HttpParametersMarshaller getInstance() {
        return instance;
    }

    public void marshall(HttpParameters httpParameters, ProtocolMarshaller protocolMarshaller) {
        if (httpParameters == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(httpParameters.getPathParameterValues(), PATHPARAMETERVALUES_BINDING);
            protocolMarshaller.marshall(httpParameters.getHeaderParameters(), HEADERPARAMETERS_BINDING);
            protocolMarshaller.marshall(httpParameters.getQueryStringParameters(), QUERYSTRINGPARAMETERS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

