/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eventbridge.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.eventbridge.model.Endpoint;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class EndpointMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Arn").build();
    private static final MarshallingInfo<StructuredPojo> ROUTINGCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoutingConfig").build();
    private static final MarshallingInfo<StructuredPojo> REPLICATIONCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicationConfig").build();
    private static final MarshallingInfo<List> EVENTBUSES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EventBuses").build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleArn").build();
    private static final MarshallingInfo<String> ENDPOINTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndpointId").build();
    private static final MarshallingInfo<String> ENDPOINTURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndpointUrl").build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").build();
    private static final MarshallingInfo<String> STATEREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StateReason").build();
    private static final MarshallingInfo<Date> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> LASTMODIFIEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModifiedTime").timestampFormat("unixTimestamp").build();
    private static final EndpointMarshaller instance = new EndpointMarshaller();

    public static EndpointMarshaller getInstance() {
        return instance;
    }

    public void marshall(Endpoint endpoint, ProtocolMarshaller protocolMarshaller) {
        if (endpoint == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)endpoint.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)endpoint.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)endpoint.getArn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)endpoint.getRoutingConfig(), ROUTINGCONFIG_BINDING);
            protocolMarshaller.marshall((Object)endpoint.getReplicationConfig(), REPLICATIONCONFIG_BINDING);
            protocolMarshaller.marshall(endpoint.getEventBuses(), EVENTBUSES_BINDING);
            protocolMarshaller.marshall((Object)endpoint.getRoleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)endpoint.getEndpointId(), ENDPOINTID_BINDING);
            protocolMarshaller.marshall((Object)endpoint.getEndpointUrl(), ENDPOINTURL_BINDING);
            protocolMarshaller.marshall((Object)endpoint.getState(), STATE_BINDING);
            protocolMarshaller.marshall((Object)endpoint.getStateReason(), STATEREASON_BINDING);
            protocolMarshaller.marshall((Object)endpoint.getCreationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)endpoint.getLastModifiedTime(), LASTMODIFIEDTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

