/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.emrcontainers.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.emrcontainers.model.Certificate;
import com.amazonaws.services.emrcontainers.model.ConfigurationOverrides;
import com.amazonaws.services.emrcontainers.model.EndpointState;
import com.amazonaws.services.emrcontainers.model.FailureReason;
import com.amazonaws.services.emrcontainers.model.transform.EndpointMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Endpoint
implements Serializable,
Cloneable,
StructuredPojo {
    private String id;
    private String name;
    private String arn;
    private String virtualClusterId;
    private String type;
    private String state;
    private String releaseLabel;
    private String executionRoleArn;
    @Deprecated
    private String certificateArn;
    private Certificate certificateAuthority;
    private ConfigurationOverrides configurationOverrides;
    private String serverUrl;
    private Date createdAt;
    private String securityGroup;
    private List<String> subnetIds;
    private String stateDetails;
    private String failureReason;
    private Map<String, String> tags;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Endpoint withId(String id) {
        this.setId(id);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Endpoint withName(String name) {
        this.setName(name);
        return this;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public Endpoint withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setVirtualClusterId(String virtualClusterId) {
        this.virtualClusterId = virtualClusterId;
    }

    public String getVirtualClusterId() {
        return this.virtualClusterId;
    }

    public Endpoint withVirtualClusterId(String virtualClusterId) {
        this.setVirtualClusterId(virtualClusterId);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public Endpoint withType(String type) {
        this.setType(type);
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public Endpoint withState(String state) {
        this.setState(state);
        return this;
    }

    public Endpoint withState(EndpointState state) {
        this.state = state.toString();
        return this;
    }

    public void setReleaseLabel(String releaseLabel) {
        this.releaseLabel = releaseLabel;
    }

    public String getReleaseLabel() {
        return this.releaseLabel;
    }

    public Endpoint withReleaseLabel(String releaseLabel) {
        this.setReleaseLabel(releaseLabel);
        return this;
    }

    public void setExecutionRoleArn(String executionRoleArn) {
        this.executionRoleArn = executionRoleArn;
    }

    public String getExecutionRoleArn() {
        return this.executionRoleArn;
    }

    public Endpoint withExecutionRoleArn(String executionRoleArn) {
        this.setExecutionRoleArn(executionRoleArn);
        return this;
    }

    @Deprecated
    public void setCertificateArn(String certificateArn) {
        this.certificateArn = certificateArn;
    }

    @Deprecated
    public String getCertificateArn() {
        return this.certificateArn;
    }

    @Deprecated
    public Endpoint withCertificateArn(String certificateArn) {
        this.setCertificateArn(certificateArn);
        return this;
    }

    public void setCertificateAuthority(Certificate certificateAuthority) {
        this.certificateAuthority = certificateAuthority;
    }

    public Certificate getCertificateAuthority() {
        return this.certificateAuthority;
    }

    public Endpoint withCertificateAuthority(Certificate certificateAuthority) {
        this.setCertificateAuthority(certificateAuthority);
        return this;
    }

    public void setConfigurationOverrides(ConfigurationOverrides configurationOverrides) {
        this.configurationOverrides = configurationOverrides;
    }

    public ConfigurationOverrides getConfigurationOverrides() {
        return this.configurationOverrides;
    }

    public Endpoint withConfigurationOverrides(ConfigurationOverrides configurationOverrides) {
        this.setConfigurationOverrides(configurationOverrides);
        return this;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public Endpoint withServerUrl(String serverUrl) {
        this.setServerUrl(serverUrl);
        return this;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Endpoint withCreatedAt(Date createdAt) {
        this.setCreatedAt(createdAt);
        return this;
    }

    public void setSecurityGroup(String securityGroup) {
        this.securityGroup = securityGroup;
    }

    public String getSecurityGroup() {
        return this.securityGroup;
    }

    public Endpoint withSecurityGroup(String securityGroup) {
        this.setSecurityGroup(securityGroup);
        return this;
    }

    public List<String> getSubnetIds() {
        return this.subnetIds;
    }

    public void setSubnetIds(Collection<String> subnetIds) {
        if (subnetIds == null) {
            this.subnetIds = null;
            return;
        }
        this.subnetIds = new ArrayList<String>(subnetIds);
    }

    public Endpoint withSubnetIds(String ... subnetIds) {
        if (this.subnetIds == null) {
            this.setSubnetIds(new ArrayList<String>(subnetIds.length));
        }
        for (String ele : subnetIds) {
            this.subnetIds.add(ele);
        }
        return this;
    }

    public Endpoint withSubnetIds(Collection<String> subnetIds) {
        this.setSubnetIds(subnetIds);
        return this;
    }

    public void setStateDetails(String stateDetails) {
        this.stateDetails = stateDetails;
    }

    public String getStateDetails() {
        return this.stateDetails;
    }

    public Endpoint withStateDetails(String stateDetails) {
        this.setStateDetails(stateDetails);
        return this;
    }

    public void setFailureReason(String failureReason) {
        this.failureReason = failureReason;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public Endpoint withFailureReason(String failureReason) {
        this.setFailureReason(failureReason);
        return this;
    }

    public Endpoint withFailureReason(FailureReason failureReason) {
        this.failureReason = failureReason.toString();
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public Endpoint withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public Endpoint addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public Endpoint clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getVirtualClusterId() != null) {
            sb.append("VirtualClusterId: ").append(this.getVirtualClusterId()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getReleaseLabel() != null) {
            sb.append("ReleaseLabel: ").append(this.getReleaseLabel()).append(",");
        }
        if (this.getExecutionRoleArn() != null) {
            sb.append("ExecutionRoleArn: ").append(this.getExecutionRoleArn()).append(",");
        }
        if (this.getCertificateArn() != null) {
            sb.append("CertificateArn: ").append(this.getCertificateArn()).append(",");
        }
        if (this.getCertificateAuthority() != null) {
            sb.append("CertificateAuthority: ").append(this.getCertificateAuthority()).append(",");
        }
        if (this.getConfigurationOverrides() != null) {
            sb.append("ConfigurationOverrides: ").append(this.getConfigurationOverrides()).append(",");
        }
        if (this.getServerUrl() != null) {
            sb.append("ServerUrl: ").append(this.getServerUrl()).append(",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: ").append(this.getCreatedAt()).append(",");
        }
        if (this.getSecurityGroup() != null) {
            sb.append("SecurityGroup: ").append(this.getSecurityGroup()).append(",");
        }
        if (this.getSubnetIds() != null) {
            sb.append("SubnetIds: ").append(this.getSubnetIds()).append(",");
        }
        if (this.getStateDetails() != null) {
            sb.append("StateDetails: ").append(this.getStateDetails()).append(",");
        }
        if (this.getFailureReason() != null) {
            sb.append("FailureReason: ").append(this.getFailureReason()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Endpoint)) {
            return false;
        }
        Endpoint other = (Endpoint)obj;
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getVirtualClusterId() == null ^ this.getVirtualClusterId() == null) {
            return false;
        }
        if (other.getVirtualClusterId() != null && !other.getVirtualClusterId().equals(this.getVirtualClusterId())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getReleaseLabel() == null ^ this.getReleaseLabel() == null) {
            return false;
        }
        if (other.getReleaseLabel() != null && !other.getReleaseLabel().equals(this.getReleaseLabel())) {
            return false;
        }
        if (other.getExecutionRoleArn() == null ^ this.getExecutionRoleArn() == null) {
            return false;
        }
        if (other.getExecutionRoleArn() != null && !other.getExecutionRoleArn().equals(this.getExecutionRoleArn())) {
            return false;
        }
        if (other.getCertificateArn() == null ^ this.getCertificateArn() == null) {
            return false;
        }
        if (other.getCertificateArn() != null && !other.getCertificateArn().equals(this.getCertificateArn())) {
            return false;
        }
        if (other.getCertificateAuthority() == null ^ this.getCertificateAuthority() == null) {
            return false;
        }
        if (other.getCertificateAuthority() != null && !other.getCertificateAuthority().equals(this.getCertificateAuthority())) {
            return false;
        }
        if (other.getConfigurationOverrides() == null ^ this.getConfigurationOverrides() == null) {
            return false;
        }
        if (other.getConfigurationOverrides() != null && !other.getConfigurationOverrides().equals(this.getConfigurationOverrides())) {
            return false;
        }
        if (other.getServerUrl() == null ^ this.getServerUrl() == null) {
            return false;
        }
        if (other.getServerUrl() != null && !other.getServerUrl().equals(this.getServerUrl())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        if (other.getCreatedAt() != null && !other.getCreatedAt().equals(this.getCreatedAt())) {
            return false;
        }
        if (other.getSecurityGroup() == null ^ this.getSecurityGroup() == null) {
            return false;
        }
        if (other.getSecurityGroup() != null && !other.getSecurityGroup().equals(this.getSecurityGroup())) {
            return false;
        }
        if (other.getSubnetIds() == null ^ this.getSubnetIds() == null) {
            return false;
        }
        if (other.getSubnetIds() != null && !other.getSubnetIds().equals(this.getSubnetIds())) {
            return false;
        }
        if (other.getStateDetails() == null ^ this.getStateDetails() == null) {
            return false;
        }
        if (other.getStateDetails() != null && !other.getStateDetails().equals(this.getStateDetails())) {
            return false;
        }
        if (other.getFailureReason() == null ^ this.getFailureReason() == null) {
            return false;
        }
        if (other.getFailureReason() != null && !other.getFailureReason().equals(this.getFailureReason())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getVirtualClusterId() == null ? 0 : this.getVirtualClusterId().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getReleaseLabel() == null ? 0 : this.getReleaseLabel().hashCode());
        hashCode = 31 * hashCode + (this.getExecutionRoleArn() == null ? 0 : this.getExecutionRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getCertificateArn() == null ? 0 : this.getCertificateArn().hashCode());
        hashCode = 31 * hashCode + (this.getCertificateAuthority() == null ? 0 : this.getCertificateAuthority().hashCode());
        hashCode = 31 * hashCode + (this.getConfigurationOverrides() == null ? 0 : this.getConfigurationOverrides().hashCode());
        hashCode = 31 * hashCode + (this.getServerUrl() == null ? 0 : this.getServerUrl().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroup() == null ? 0 : this.getSecurityGroup().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetIds() == null ? 0 : this.getSubnetIds().hashCode());
        hashCode = 31 * hashCode + (this.getStateDetails() == null ? 0 : this.getStateDetails().hashCode());
        hashCode = 31 * hashCode + (this.getFailureReason() == null ? 0 : this.getFailureReason().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public Endpoint clone() {
        try {
            return (Endpoint)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EndpointMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

