/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.elasticmapreduce.model.transform.HadoopStepConfigMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class HadoopStepConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String jar;
    private SdkInternalMap<String, String> properties;
    private String mainClass;
    private SdkInternalList<String> args;

    public void setJar(String jar) {
        this.jar = jar;
    }

    public String getJar() {
        return this.jar;
    }

    public HadoopStepConfig withJar(String jar) {
        this.setJar(jar);
        return this;
    }

    public Map<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = new SdkInternalMap();
        }
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties == null ? null : new SdkInternalMap(properties);
    }

    public HadoopStepConfig withProperties(Map<String, String> properties) {
        this.setProperties(properties);
        return this;
    }

    public HadoopStepConfig addPropertiesEntry(String key, String value) {
        if (null == this.properties) {
            this.properties = new SdkInternalMap();
        }
        if (this.properties.containsKey((Object)key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.properties.put((Object)key, (Object)value);
        return this;
    }

    public HadoopStepConfig clearPropertiesEntries() {
        this.properties = null;
        return this;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public HadoopStepConfig withMainClass(String mainClass) {
        this.setMainClass(mainClass);
        return this;
    }

    public List<String> getArgs() {
        if (this.args == null) {
            this.args = new SdkInternalList();
        }
        return this.args;
    }

    public void setArgs(Collection<String> args) {
        if (args == null) {
            this.args = null;
            return;
        }
        this.args = new SdkInternalList(args);
    }

    public HadoopStepConfig withArgs(String ... args) {
        if (this.args == null) {
            this.setArgs((Collection<String>)new SdkInternalList(args.length));
        }
        for (String ele : args) {
            this.args.add((Object)ele);
        }
        return this;
    }

    public HadoopStepConfig withArgs(Collection<String> args) {
        this.setArgs(args);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getJar() != null) {
            sb.append("Jar: ").append(this.getJar()).append(",");
        }
        if (this.getProperties() != null) {
            sb.append("Properties: ").append(this.getProperties()).append(",");
        }
        if (this.getMainClass() != null) {
            sb.append("MainClass: ").append(this.getMainClass()).append(",");
        }
        if (this.getArgs() != null) {
            sb.append("Args: ").append(this.getArgs());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HadoopStepConfig)) {
            return false;
        }
        HadoopStepConfig other = (HadoopStepConfig)obj;
        if (other.getJar() == null ^ this.getJar() == null) {
            return false;
        }
        if (other.getJar() != null && !other.getJar().equals(this.getJar())) {
            return false;
        }
        if (other.getProperties() == null ^ this.getProperties() == null) {
            return false;
        }
        if (other.getProperties() != null && !other.getProperties().equals(this.getProperties())) {
            return false;
        }
        if (other.getMainClass() == null ^ this.getMainClass() == null) {
            return false;
        }
        if (other.getMainClass() != null && !other.getMainClass().equals(this.getMainClass())) {
            return false;
        }
        if (other.getArgs() == null ^ this.getArgs() == null) {
            return false;
        }
        return other.getArgs() == null || other.getArgs().equals(this.getArgs());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getJar() == null ? 0 : this.getJar().hashCode());
        hashCode = 31 * hashCode + (this.getProperties() == null ? 0 : this.getProperties().hashCode());
        hashCode = 31 * hashCode + (this.getMainClass() == null ? 0 : this.getMainClass().hashCode());
        hashCode = 31 * hashCode + (this.getArgs() == null ? 0 : this.getArgs().hashCode());
        return hashCode;
    }

    public HadoopStepConfig clone() {
        try {
            return (HadoopStepConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HadoopStepConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

