/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.elastictranscoder.AmazonElasticTranscoder;
import com.amazonaws.services.elastictranscoder.AmazonElasticTranscoderClientBuilder;
import com.amazonaws.services.elastictranscoder.model.AmazonElasticTranscoderException;
import com.amazonaws.services.elastictranscoder.model.CancelJobRequest;
import com.amazonaws.services.elastictranscoder.model.CancelJobResult;
import com.amazonaws.services.elastictranscoder.model.CreateJobRequest;
import com.amazonaws.services.elastictranscoder.model.CreateJobResult;
import com.amazonaws.services.elastictranscoder.model.CreatePipelineRequest;
import com.amazonaws.services.elastictranscoder.model.CreatePipelineResult;
import com.amazonaws.services.elastictranscoder.model.CreatePresetRequest;
import com.amazonaws.services.elastictranscoder.model.CreatePresetResult;
import com.amazonaws.services.elastictranscoder.model.DeletePipelineRequest;
import com.amazonaws.services.elastictranscoder.model.DeletePipelineResult;
import com.amazonaws.services.elastictranscoder.model.DeletePresetRequest;
import com.amazonaws.services.elastictranscoder.model.DeletePresetResult;
import com.amazonaws.services.elastictranscoder.model.ListJobsByPipelineRequest;
import com.amazonaws.services.elastictranscoder.model.ListJobsByPipelineResult;
import com.amazonaws.services.elastictranscoder.model.ListJobsByStatusRequest;
import com.amazonaws.services.elastictranscoder.model.ListJobsByStatusResult;
import com.amazonaws.services.elastictranscoder.model.ListPipelinesRequest;
import com.amazonaws.services.elastictranscoder.model.ListPipelinesResult;
import com.amazonaws.services.elastictranscoder.model.ListPresetsRequest;
import com.amazonaws.services.elastictranscoder.model.ListPresetsResult;
import com.amazonaws.services.elastictranscoder.model.ReadJobRequest;
import com.amazonaws.services.elastictranscoder.model.ReadJobResult;
import com.amazonaws.services.elastictranscoder.model.ReadPipelineRequest;
import com.amazonaws.services.elastictranscoder.model.ReadPipelineResult;
import com.amazonaws.services.elastictranscoder.model.ReadPresetRequest;
import com.amazonaws.services.elastictranscoder.model.ReadPresetResult;
import com.amazonaws.services.elastictranscoder.model.TestRoleRequest;
import com.amazonaws.services.elastictranscoder.model.TestRoleResult;
import com.amazonaws.services.elastictranscoder.model.UpdatePipelineNotificationsRequest;
import com.amazonaws.services.elastictranscoder.model.UpdatePipelineNotificationsResult;
import com.amazonaws.services.elastictranscoder.model.UpdatePipelineRequest;
import com.amazonaws.services.elastictranscoder.model.UpdatePipelineResult;
import com.amazonaws.services.elastictranscoder.model.UpdatePipelineStatusRequest;
import com.amazonaws.services.elastictranscoder.model.UpdatePipelineStatusResult;
import com.amazonaws.services.elastictranscoder.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.CancelJobRequestProtocolMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.CancelJobResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.CreateJobRequestProtocolMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.CreateJobResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.CreatePipelineRequestProtocolMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.CreatePipelineResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.CreatePresetRequestProtocolMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.CreatePresetResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.DeletePipelineRequestProtocolMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.DeletePipelineResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.DeletePresetRequestProtocolMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.DeletePresetResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.IncompatibleVersionExceptionUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.InternalServiceExceptionUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ListJobsByPipelineRequestProtocolMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ListJobsByPipelineResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ListJobsByStatusRequestProtocolMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ListJobsByStatusResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ListPipelinesRequestProtocolMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ListPipelinesResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ListPresetsRequestProtocolMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ListPresetsResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ReadJobRequestProtocolMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ReadJobResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ReadPipelineRequestProtocolMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ReadPipelineResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ReadPresetRequestProtocolMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ReadPresetResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ResourceInUseExceptionUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.TestRoleRequestProtocolMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.TestRoleResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.UpdatePipelineNotificationsRequestProtocolMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.UpdatePipelineNotificationsResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.UpdatePipelineRequestProtocolMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.UpdatePipelineResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.UpdatePipelineStatusRequestProtocolMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.UpdatePipelineStatusResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.services.elastictranscoder.waiters.AmazonElasticTranscoderWaiters;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonElasticTranscoderClient
extends AmazonWebServiceClient
implements AmazonElasticTranscoder {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonElasticTranscoder.class);
    private static final String DEFAULT_SIGNING_NAME = "elastictranscoder";
    private volatile AmazonElasticTranscoderWaiters waiters;
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceInUseException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceInUseExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("IncompatibleVersionException").withExceptionUnmarshaller((JsonErrorUnmarshaller)IncompatibleVersionExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServiceException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServiceExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)LimitExceededExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AmazonElasticTranscoderException.class));

    @Deprecated
    public AmazonElasticTranscoderClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), configFactory.getConfig());
    }

    @Deprecated
    public AmazonElasticTranscoderClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration);
    }

    @Deprecated
    public AmazonElasticTranscoderClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    @Deprecated
    public AmazonElasticTranscoderClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.advancedConfig = AdvancedConfig.EMPTY;
        this.init();
    }

    @Deprecated
    public AmazonElasticTranscoderClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    @Deprecated
    public AmazonElasticTranscoderClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    @Deprecated
    public AmazonElasticTranscoderClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.advancedConfig = AdvancedConfig.EMPTY;
        this.init();
    }

    public static AmazonElasticTranscoderClientBuilder builder() {
        return AmazonElasticTranscoderClientBuilder.standard();
    }

    AmazonElasticTranscoderClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonElasticTranscoderClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("elastictranscoder.us-east-1.amazonaws.com/");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/elastictranscoder/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/elastictranscoder/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CancelJobResult cancelJob(CancelJobRequest request) {
        request = (CancelJobRequest)this.beforeClientExecution(request);
        return this.executeCancelJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CancelJobResult executeCancelJob(CancelJobRequest cancelJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(cancelJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CancelJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CancelJobRequestProtocolMarshaller(protocolFactory).marshall((CancelJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)cancelJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Elastic Transcoder");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CancelJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CancelJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CancelJobResult cancelJobResult = (CancelJobResult)response.getAwsResponse();
            return cancelJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateJobResult createJob(CreateJobRequest request) {
        request = (CreateJobRequest)this.beforeClientExecution(request);
        return this.executeCreateJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateJobResult executeCreateJob(CreateJobRequest createJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateJobRequestProtocolMarshaller(protocolFactory).marshall((CreateJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)createJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Elastic Transcoder");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateJobResult createJobResult = (CreateJobResult)response.getAwsResponse();
            return createJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreatePipelineResult createPipeline(CreatePipelineRequest request) {
        request = (CreatePipelineRequest)this.beforeClientExecution(request);
        return this.executeCreatePipeline(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreatePipelineResult executeCreatePipeline(CreatePipelineRequest createPipelineRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createPipelineRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreatePipelineRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreatePipelineRequestProtocolMarshaller(protocolFactory).marshall((CreatePipelineRequest)super.beforeMarshalling((AmazonWebServiceRequest)createPipelineRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Elastic Transcoder");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreatePipeline");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreatePipelineResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreatePipelineResult createPipelineResult = (CreatePipelineResult)response.getAwsResponse();
            return createPipelineResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreatePresetResult createPreset(CreatePresetRequest request) {
        request = (CreatePresetRequest)this.beforeClientExecution(request);
        return this.executeCreatePreset(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreatePresetResult executeCreatePreset(CreatePresetRequest createPresetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createPresetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreatePresetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreatePresetRequestProtocolMarshaller(protocolFactory).marshall((CreatePresetRequest)super.beforeMarshalling((AmazonWebServiceRequest)createPresetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Elastic Transcoder");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreatePreset");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreatePresetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreatePresetResult createPresetResult = (CreatePresetResult)response.getAwsResponse();
            return createPresetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeletePipelineResult deletePipeline(DeletePipelineRequest request) {
        request = (DeletePipelineRequest)this.beforeClientExecution(request);
        return this.executeDeletePipeline(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeletePipelineResult executeDeletePipeline(DeletePipelineRequest deletePipelineRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deletePipelineRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeletePipelineRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeletePipelineRequestProtocolMarshaller(protocolFactory).marshall((DeletePipelineRequest)super.beforeMarshalling((AmazonWebServiceRequest)deletePipelineRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Elastic Transcoder");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeletePipeline");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeletePipelineResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeletePipelineResult deletePipelineResult = (DeletePipelineResult)response.getAwsResponse();
            return deletePipelineResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeletePresetResult deletePreset(DeletePresetRequest request) {
        request = (DeletePresetRequest)this.beforeClientExecution(request);
        return this.executeDeletePreset(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeletePresetResult executeDeletePreset(DeletePresetRequest deletePresetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deletePresetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeletePresetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeletePresetRequestProtocolMarshaller(protocolFactory).marshall((DeletePresetRequest)super.beforeMarshalling((AmazonWebServiceRequest)deletePresetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Elastic Transcoder");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeletePreset");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeletePresetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeletePresetResult deletePresetResult = (DeletePresetResult)response.getAwsResponse();
            return deletePresetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListJobsByPipelineResult listJobsByPipeline(ListJobsByPipelineRequest request) {
        request = (ListJobsByPipelineRequest)this.beforeClientExecution(request);
        return this.executeListJobsByPipeline(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListJobsByPipelineResult executeListJobsByPipeline(ListJobsByPipelineRequest listJobsByPipelineRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listJobsByPipelineRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListJobsByPipelineRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListJobsByPipelineRequestProtocolMarshaller(protocolFactory).marshall((ListJobsByPipelineRequest)super.beforeMarshalling((AmazonWebServiceRequest)listJobsByPipelineRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Elastic Transcoder");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListJobsByPipeline");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListJobsByPipelineResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListJobsByPipelineResult listJobsByPipelineResult = (ListJobsByPipelineResult)response.getAwsResponse();
            return listJobsByPipelineResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListJobsByStatusResult listJobsByStatus(ListJobsByStatusRequest request) {
        request = (ListJobsByStatusRequest)this.beforeClientExecution(request);
        return this.executeListJobsByStatus(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListJobsByStatusResult executeListJobsByStatus(ListJobsByStatusRequest listJobsByStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listJobsByStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListJobsByStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListJobsByStatusRequestProtocolMarshaller(protocolFactory).marshall((ListJobsByStatusRequest)super.beforeMarshalling((AmazonWebServiceRequest)listJobsByStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Elastic Transcoder");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListJobsByStatus");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListJobsByStatusResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListJobsByStatusResult listJobsByStatusResult = (ListJobsByStatusResult)response.getAwsResponse();
            return listJobsByStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListPipelinesResult listPipelines(ListPipelinesRequest request) {
        request = (ListPipelinesRequest)this.beforeClientExecution(request);
        return this.executeListPipelines(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListPipelinesResult executeListPipelines(ListPipelinesRequest listPipelinesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listPipelinesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListPipelinesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListPipelinesRequestProtocolMarshaller(protocolFactory).marshall((ListPipelinesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listPipelinesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Elastic Transcoder");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListPipelines");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListPipelinesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListPipelinesResult listPipelinesResult = (ListPipelinesResult)response.getAwsResponse();
            return listPipelinesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListPipelinesResult listPipelines() {
        return this.listPipelines(new ListPipelinesRequest());
    }

    @Override
    public ListPresetsResult listPresets(ListPresetsRequest request) {
        request = (ListPresetsRequest)this.beforeClientExecution(request);
        return this.executeListPresets(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListPresetsResult executeListPresets(ListPresetsRequest listPresetsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listPresetsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListPresetsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListPresetsRequestProtocolMarshaller(protocolFactory).marshall((ListPresetsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listPresetsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Elastic Transcoder");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListPresets");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListPresetsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListPresetsResult listPresetsResult = (ListPresetsResult)response.getAwsResponse();
            return listPresetsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListPresetsResult listPresets() {
        return this.listPresets(new ListPresetsRequest());
    }

    @Override
    public ReadJobResult readJob(ReadJobRequest request) {
        request = (ReadJobRequest)this.beforeClientExecution(request);
        return this.executeReadJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ReadJobResult executeReadJob(ReadJobRequest readJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(readJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ReadJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ReadJobRequestProtocolMarshaller(protocolFactory).marshall((ReadJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)readJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Elastic Transcoder");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ReadJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ReadJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ReadJobResult readJobResult = (ReadJobResult)response.getAwsResponse();
            return readJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ReadPipelineResult readPipeline(ReadPipelineRequest request) {
        request = (ReadPipelineRequest)this.beforeClientExecution(request);
        return this.executeReadPipeline(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ReadPipelineResult executeReadPipeline(ReadPipelineRequest readPipelineRequest) {
        ExecutionContext executionContext = this.createExecutionContext(readPipelineRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ReadPipelineRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ReadPipelineRequestProtocolMarshaller(protocolFactory).marshall((ReadPipelineRequest)super.beforeMarshalling((AmazonWebServiceRequest)readPipelineRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Elastic Transcoder");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ReadPipeline");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ReadPipelineResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ReadPipelineResult readPipelineResult = (ReadPipelineResult)response.getAwsResponse();
            return readPipelineResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ReadPresetResult readPreset(ReadPresetRequest request) {
        request = (ReadPresetRequest)this.beforeClientExecution(request);
        return this.executeReadPreset(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ReadPresetResult executeReadPreset(ReadPresetRequest readPresetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(readPresetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ReadPresetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ReadPresetRequestProtocolMarshaller(protocolFactory).marshall((ReadPresetRequest)super.beforeMarshalling((AmazonWebServiceRequest)readPresetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Elastic Transcoder");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ReadPreset");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ReadPresetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ReadPresetResult readPresetResult = (ReadPresetResult)response.getAwsResponse();
            return readPresetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    @Deprecated
    public TestRoleResult testRole(TestRoleRequest request) {
        request = (TestRoleRequest)this.beforeClientExecution(request);
        return this.executeTestRole(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TestRoleResult executeTestRole(TestRoleRequest testRoleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(testRoleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TestRoleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TestRoleRequestProtocolMarshaller(protocolFactory).marshall((TestRoleRequest)super.beforeMarshalling((AmazonWebServiceRequest)testRoleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Elastic Transcoder");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TestRole");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TestRoleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TestRoleResult testRoleResult = (TestRoleResult)response.getAwsResponse();
            return testRoleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdatePipelineResult updatePipeline(UpdatePipelineRequest request) {
        request = (UpdatePipelineRequest)this.beforeClientExecution(request);
        return this.executeUpdatePipeline(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdatePipelineResult executeUpdatePipeline(UpdatePipelineRequest updatePipelineRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updatePipelineRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdatePipelineRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdatePipelineRequestProtocolMarshaller(protocolFactory).marshall((UpdatePipelineRequest)super.beforeMarshalling((AmazonWebServiceRequest)updatePipelineRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Elastic Transcoder");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdatePipeline");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdatePipelineResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdatePipelineResult updatePipelineResult = (UpdatePipelineResult)response.getAwsResponse();
            return updatePipelineResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdatePipelineNotificationsResult updatePipelineNotifications(UpdatePipelineNotificationsRequest request) {
        request = (UpdatePipelineNotificationsRequest)this.beforeClientExecution(request);
        return this.executeUpdatePipelineNotifications(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdatePipelineNotificationsResult executeUpdatePipelineNotifications(UpdatePipelineNotificationsRequest updatePipelineNotificationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updatePipelineNotificationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdatePipelineNotificationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdatePipelineNotificationsRequestProtocolMarshaller(protocolFactory).marshall((UpdatePipelineNotificationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)updatePipelineNotificationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Elastic Transcoder");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdatePipelineNotifications");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdatePipelineNotificationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdatePipelineNotificationsResult updatePipelineNotificationsResult = (UpdatePipelineNotificationsResult)response.getAwsResponse();
            return updatePipelineNotificationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdatePipelineStatusResult updatePipelineStatus(UpdatePipelineStatusRequest request) {
        request = (UpdatePipelineStatusRequest)this.beforeClientExecution(request);
        return this.executeUpdatePipelineStatus(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdatePipelineStatusResult executeUpdatePipelineStatus(UpdatePipelineStatusRequest updatePipelineStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updatePipelineStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdatePipelineStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdatePipelineStatusRequestProtocolMarshaller(protocolFactory).marshall((UpdatePipelineStatusRequest)super.beforeMarshalling((AmazonWebServiceRequest)updatePipelineStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Elastic Transcoder");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdatePipelineStatus");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdatePipelineStatusResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdatePipelineStatusResult updatePipelineStatusResult = (UpdatePipelineStatusResult)response.getAwsResponse();
            return updatePipelineStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AmazonElasticTranscoderWaiters waiters() {
        if (this.waiters == null) {
            AmazonElasticTranscoderClient amazonElasticTranscoderClient = this;
            synchronized (amazonElasticTranscoderClient) {
                if (this.waiters == null) {
                    this.waiters = new AmazonElasticTranscoderWaiters(this);
                }
            }
        }
        return this.waiters;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.waiters != null) {
            this.waiters.shutdown();
        }
    }
}

