/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticbeanstalk.model.ListPlatformVersionsRequest;
import com.amazonaws.services.elasticbeanstalk.model.PlatformFilter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListPlatformVersionsRequestMarshaller
implements Marshaller<Request<ListPlatformVersionsRequest>, ListPlatformVersionsRequest> {
    public Request<ListPlatformVersionsRequest> marshall(ListPlatformVersionsRequest listPlatformVersionsRequest) {
        if (listPlatformVersionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listPlatformVersionsRequest, "AWSElasticBeanstalk");
        request.addParameter("Action", "ListPlatformVersions");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList filtersList = (SdkInternalList)listPlatformVersionsRequest.getFilters();
        if (!filtersList.isEmpty() || !filtersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (PlatformFilter filtersListValue : filtersList) {
                SdkInternalList valuesList;
                if (filtersListValue.getType() != null) {
                    request.addParameter("Filters.member." + filtersListIndex + ".Type", StringUtils.fromString((String)filtersListValue.getType()));
                }
                if (filtersListValue.getOperator() != null) {
                    request.addParameter("Filters.member." + filtersListIndex + ".Operator", StringUtils.fromString((String)filtersListValue.getOperator()));
                }
                if (!(valuesList = (SdkInternalList)filtersListValue.getValues()).isEmpty() || !valuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filters.member." + filtersListIndex + ".Values.member." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (listPlatformVersionsRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)listPlatformVersionsRequest.getMaxRecords()));
        }
        if (listPlatformVersionsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)listPlatformVersionsRequest.getNextToken()));
        }
        return request;
    }
}

