/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticache.model.CreateCacheSubnetGroupRequest;
import com.amazonaws.services.elasticache.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateCacheSubnetGroupRequestMarshaller
implements Marshaller<Request<CreateCacheSubnetGroupRequest>, CreateCacheSubnetGroupRequest> {
    public Request<CreateCacheSubnetGroupRequest> marshall(CreateCacheSubnetGroupRequest createCacheSubnetGroupRequest) {
        if (createCacheSubnetGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createCacheSubnetGroupRequest, "AmazonElastiCache");
        request.addParameter("Action", "CreateCacheSubnetGroup");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (createCacheSubnetGroupRequest.getCacheSubnetGroupName() != null) {
            request.addParameter("CacheSubnetGroupName", StringUtils.fromString((String)createCacheSubnetGroupRequest.getCacheSubnetGroupName()));
        }
        if (createCacheSubnetGroupRequest.getCacheSubnetGroupDescription() != null) {
            request.addParameter("CacheSubnetGroupDescription", StringUtils.fromString((String)createCacheSubnetGroupRequest.getCacheSubnetGroupDescription()));
        }
        if (!createCacheSubnetGroupRequest.getSubnetIds().isEmpty() || !((SdkInternalList)createCacheSubnetGroupRequest.getSubnetIds()).isAutoConstruct()) {
            SdkInternalList subnetIdsList = (SdkInternalList)createCacheSubnetGroupRequest.getSubnetIds();
            int subnetIdsListIndex = 1;
            for (String subnetIdsListValue : subnetIdsList) {
                if (subnetIdsListValue != null) {
                    request.addParameter("SubnetIds.SubnetIdentifier." + subnetIdsListIndex, StringUtils.fromString((String)subnetIdsListValue));
                }
                ++subnetIdsListIndex;
            }
        }
        if (!createCacheSubnetGroupRequest.getTags().isEmpty() || !((SdkInternalList)createCacheSubnetGroupRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)createCacheSubnetGroupRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue != null) {
                    if (tagsListValue.getKey() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                    }
                    if (tagsListValue.getValue() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                    }
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

