/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticache.model.DescribeUsersRequest;
import com.amazonaws.services.elasticache.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeUsersRequestMarshaller
implements Marshaller<Request<DescribeUsersRequest>, DescribeUsersRequest> {
    public Request<DescribeUsersRequest> marshall(DescribeUsersRequest describeUsersRequest) {
        if (describeUsersRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeUsersRequest, "AmazonElastiCache");
        request.addParameter("Action", "DescribeUsers");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeUsersRequest.getEngine() != null) {
            request.addParameter("Engine", StringUtils.fromString((String)describeUsersRequest.getEngine()));
        }
        if (describeUsersRequest.getUserId() != null) {
            request.addParameter("UserId", StringUtils.fromString((String)describeUsersRequest.getUserId()));
        }
        if (!describeUsersRequest.getFilters().isEmpty() || !((SdkInternalList)describeUsersRequest.getFilters()).isAutoConstruct()) {
            SdkInternalList filtersList = (SdkInternalList)describeUsersRequest.getFilters();
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                if (filtersListValue != null) {
                    if (filtersListValue.getName() != null) {
                        request.addParameter("Filters.member." + filtersListIndex + ".Name", StringUtils.fromString((String)filtersListValue.getName()));
                    }
                    if (!filtersListValue.getValues().isEmpty() || !((SdkInternalList)filtersListValue.getValues()).isAutoConstruct()) {
                        SdkInternalList valuesList = (SdkInternalList)filtersListValue.getValues();
                        int valuesListIndex = 1;
                        for (String valuesListValue : valuesList) {
                            if (valuesListValue != null) {
                                request.addParameter("Filters.member." + filtersListIndex + ".Values.member." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                            }
                            ++valuesListIndex;
                        }
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeUsersRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeUsersRequest.getMaxRecords()));
        }
        if (describeUsersRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeUsersRequest.getMarker()));
        }
        return request;
    }
}

