/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticache.model.DescribeCacheParametersRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeCacheParametersRequestMarshaller
implements Marshaller<Request<DescribeCacheParametersRequest>, DescribeCacheParametersRequest> {
    public Request<DescribeCacheParametersRequest> marshall(DescribeCacheParametersRequest describeCacheParametersRequest) {
        if (describeCacheParametersRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeCacheParametersRequest, "AmazonElastiCache");
        request.addParameter("Action", "DescribeCacheParameters");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeCacheParametersRequest.getCacheParameterGroupName() != null) {
            request.addParameter("CacheParameterGroupName", StringUtils.fromString((String)describeCacheParametersRequest.getCacheParameterGroupName()));
        }
        if (describeCacheParametersRequest.getSource() != null) {
            request.addParameter("Source", StringUtils.fromString((String)describeCacheParametersRequest.getSource()));
        }
        if (describeCacheParametersRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeCacheParametersRequest.getMaxRecords()));
        }
        if (describeCacheParametersRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeCacheParametersRequest.getMarker()));
        }
        return request;
    }
}

