/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eks.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.eks.model.Certificate;
import com.amazonaws.services.eks.model.ClusterHealth;
import com.amazonaws.services.eks.model.ClusterStatus;
import com.amazonaws.services.eks.model.ConnectorConfigResponse;
import com.amazonaws.services.eks.model.EncryptionConfig;
import com.amazonaws.services.eks.model.Identity;
import com.amazonaws.services.eks.model.KubernetesNetworkConfigResponse;
import com.amazonaws.services.eks.model.Logging;
import com.amazonaws.services.eks.model.OutpostConfigResponse;
import com.amazonaws.services.eks.model.VpcConfigResponse;
import com.amazonaws.services.eks.model.transform.ClusterMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Cluster
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String arn;
    private Date createdAt;
    private String version;
    private String endpoint;
    private String roleArn;
    private VpcConfigResponse resourcesVpcConfig;
    private KubernetesNetworkConfigResponse kubernetesNetworkConfig;
    private Logging logging;
    private Identity identity;
    private String status;
    private Certificate certificateAuthority;
    private String clientRequestToken;
    private String platformVersion;
    private Map<String, String> tags;
    private List<EncryptionConfig> encryptionConfig;
    private ConnectorConfigResponse connectorConfig;
    private String id;
    private ClusterHealth health;
    private OutpostConfigResponse outpostConfig;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Cluster withName(String name) {
        this.setName(name);
        return this;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public Cluster withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Cluster withCreatedAt(Date createdAt) {
        this.setCreatedAt(createdAt);
        return this;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public Cluster withVersion(String version) {
        this.setVersion(version);
        return this;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public Cluster withEndpoint(String endpoint) {
        this.setEndpoint(endpoint);
        return this;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public Cluster withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public void setResourcesVpcConfig(VpcConfigResponse resourcesVpcConfig) {
        this.resourcesVpcConfig = resourcesVpcConfig;
    }

    public VpcConfigResponse getResourcesVpcConfig() {
        return this.resourcesVpcConfig;
    }

    public Cluster withResourcesVpcConfig(VpcConfigResponse resourcesVpcConfig) {
        this.setResourcesVpcConfig(resourcesVpcConfig);
        return this;
    }

    public void setKubernetesNetworkConfig(KubernetesNetworkConfigResponse kubernetesNetworkConfig) {
        this.kubernetesNetworkConfig = kubernetesNetworkConfig;
    }

    public KubernetesNetworkConfigResponse getKubernetesNetworkConfig() {
        return this.kubernetesNetworkConfig;
    }

    public Cluster withKubernetesNetworkConfig(KubernetesNetworkConfigResponse kubernetesNetworkConfig) {
        this.setKubernetesNetworkConfig(kubernetesNetworkConfig);
        return this;
    }

    public void setLogging(Logging logging) {
        this.logging = logging;
    }

    public Logging getLogging() {
        return this.logging;
    }

    public Cluster withLogging(Logging logging) {
        this.setLogging(logging);
        return this;
    }

    public void setIdentity(Identity identity) {
        this.identity = identity;
    }

    public Identity getIdentity() {
        return this.identity;
    }

    public Cluster withIdentity(Identity identity) {
        this.setIdentity(identity);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public Cluster withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public Cluster withStatus(ClusterStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setCertificateAuthority(Certificate certificateAuthority) {
        this.certificateAuthority = certificateAuthority;
    }

    public Certificate getCertificateAuthority() {
        return this.certificateAuthority;
    }

    public Cluster withCertificateAuthority(Certificate certificateAuthority) {
        this.setCertificateAuthority(certificateAuthority);
        return this;
    }

    public void setClientRequestToken(String clientRequestToken) {
        this.clientRequestToken = clientRequestToken;
    }

    public String getClientRequestToken() {
        return this.clientRequestToken;
    }

    public Cluster withClientRequestToken(String clientRequestToken) {
        this.setClientRequestToken(clientRequestToken);
        return this;
    }

    public void setPlatformVersion(String platformVersion) {
        this.platformVersion = platformVersion;
    }

    public String getPlatformVersion() {
        return this.platformVersion;
    }

    public Cluster withPlatformVersion(String platformVersion) {
        this.setPlatformVersion(platformVersion);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public Cluster withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public Cluster addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public Cluster clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public List<EncryptionConfig> getEncryptionConfig() {
        return this.encryptionConfig;
    }

    public void setEncryptionConfig(Collection<EncryptionConfig> encryptionConfig) {
        if (encryptionConfig == null) {
            this.encryptionConfig = null;
            return;
        }
        this.encryptionConfig = new ArrayList<EncryptionConfig>(encryptionConfig);
    }

    public Cluster withEncryptionConfig(EncryptionConfig ... encryptionConfig) {
        if (this.encryptionConfig == null) {
            this.setEncryptionConfig(new ArrayList<EncryptionConfig>(encryptionConfig.length));
        }
        for (EncryptionConfig ele : encryptionConfig) {
            this.encryptionConfig.add(ele);
        }
        return this;
    }

    public Cluster withEncryptionConfig(Collection<EncryptionConfig> encryptionConfig) {
        this.setEncryptionConfig(encryptionConfig);
        return this;
    }

    public void setConnectorConfig(ConnectorConfigResponse connectorConfig) {
        this.connectorConfig = connectorConfig;
    }

    public ConnectorConfigResponse getConnectorConfig() {
        return this.connectorConfig;
    }

    public Cluster withConnectorConfig(ConnectorConfigResponse connectorConfig) {
        this.setConnectorConfig(connectorConfig);
        return this;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Cluster withId(String id) {
        this.setId(id);
        return this;
    }

    public void setHealth(ClusterHealth health) {
        this.health = health;
    }

    public ClusterHealth getHealth() {
        return this.health;
    }

    public Cluster withHealth(ClusterHealth health) {
        this.setHealth(health);
        return this;
    }

    public void setOutpostConfig(OutpostConfigResponse outpostConfig) {
        this.outpostConfig = outpostConfig;
    }

    public OutpostConfigResponse getOutpostConfig() {
        return this.outpostConfig;
    }

    public Cluster withOutpostConfig(OutpostConfigResponse outpostConfig) {
        this.setOutpostConfig(outpostConfig);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: ").append(this.getCreatedAt()).append(",");
        }
        if (this.getVersion() != null) {
            sb.append("Version: ").append(this.getVersion()).append(",");
        }
        if (this.getEndpoint() != null) {
            sb.append("Endpoint: ").append(this.getEndpoint()).append(",");
        }
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: ").append(this.getRoleArn()).append(",");
        }
        if (this.getResourcesVpcConfig() != null) {
            sb.append("ResourcesVpcConfig: ").append(this.getResourcesVpcConfig()).append(",");
        }
        if (this.getKubernetesNetworkConfig() != null) {
            sb.append("KubernetesNetworkConfig: ").append(this.getKubernetesNetworkConfig()).append(",");
        }
        if (this.getLogging() != null) {
            sb.append("Logging: ").append(this.getLogging()).append(",");
        }
        if (this.getIdentity() != null) {
            sb.append("Identity: ").append(this.getIdentity()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getCertificateAuthority() != null) {
            sb.append("CertificateAuthority: ").append(this.getCertificateAuthority()).append(",");
        }
        if (this.getClientRequestToken() != null) {
            sb.append("ClientRequestToken: ").append(this.getClientRequestToken()).append(",");
        }
        if (this.getPlatformVersion() != null) {
            sb.append("PlatformVersion: ").append(this.getPlatformVersion()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getEncryptionConfig() != null) {
            sb.append("EncryptionConfig: ").append(this.getEncryptionConfig()).append(",");
        }
        if (this.getConnectorConfig() != null) {
            sb.append("ConnectorConfig: ").append(this.getConnectorConfig()).append(",");
        }
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getHealth() != null) {
            sb.append("Health: ").append(this.getHealth()).append(",");
        }
        if (this.getOutpostConfig() != null) {
            sb.append("OutpostConfig: ").append(this.getOutpostConfig());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cluster)) {
            return false;
        }
        Cluster other = (Cluster)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        if (other.getCreatedAt() != null && !other.getCreatedAt().equals(this.getCreatedAt())) {
            return false;
        }
        if (other.getVersion() == null ^ this.getVersion() == null) {
            return false;
        }
        if (other.getVersion() != null && !other.getVersion().equals(this.getVersion())) {
            return false;
        }
        if (other.getEndpoint() == null ^ this.getEndpoint() == null) {
            return false;
        }
        if (other.getEndpoint() != null && !other.getEndpoint().equals(this.getEndpoint())) {
            return false;
        }
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        if (other.getRoleArn() != null && !other.getRoleArn().equals(this.getRoleArn())) {
            return false;
        }
        if (other.getResourcesVpcConfig() == null ^ this.getResourcesVpcConfig() == null) {
            return false;
        }
        if (other.getResourcesVpcConfig() != null && !other.getResourcesVpcConfig().equals(this.getResourcesVpcConfig())) {
            return false;
        }
        if (other.getKubernetesNetworkConfig() == null ^ this.getKubernetesNetworkConfig() == null) {
            return false;
        }
        if (other.getKubernetesNetworkConfig() != null && !other.getKubernetesNetworkConfig().equals(this.getKubernetesNetworkConfig())) {
            return false;
        }
        if (other.getLogging() == null ^ this.getLogging() == null) {
            return false;
        }
        if (other.getLogging() != null && !other.getLogging().equals(this.getLogging())) {
            return false;
        }
        if (other.getIdentity() == null ^ this.getIdentity() == null) {
            return false;
        }
        if (other.getIdentity() != null && !other.getIdentity().equals(this.getIdentity())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getCertificateAuthority() == null ^ this.getCertificateAuthority() == null) {
            return false;
        }
        if (other.getCertificateAuthority() != null && !other.getCertificateAuthority().equals(this.getCertificateAuthority())) {
            return false;
        }
        if (other.getClientRequestToken() == null ^ this.getClientRequestToken() == null) {
            return false;
        }
        if (other.getClientRequestToken() != null && !other.getClientRequestToken().equals(this.getClientRequestToken())) {
            return false;
        }
        if (other.getPlatformVersion() == null ^ this.getPlatformVersion() == null) {
            return false;
        }
        if (other.getPlatformVersion() != null && !other.getPlatformVersion().equals(this.getPlatformVersion())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getEncryptionConfig() == null ^ this.getEncryptionConfig() == null) {
            return false;
        }
        if (other.getEncryptionConfig() != null && !other.getEncryptionConfig().equals(this.getEncryptionConfig())) {
            return false;
        }
        if (other.getConnectorConfig() == null ^ this.getConnectorConfig() == null) {
            return false;
        }
        if (other.getConnectorConfig() != null && !other.getConnectorConfig().equals(this.getConnectorConfig())) {
            return false;
        }
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getHealth() == null ^ this.getHealth() == null) {
            return false;
        }
        if (other.getHealth() != null && !other.getHealth().equals(this.getHealth())) {
            return false;
        }
        if (other.getOutpostConfig() == null ^ this.getOutpostConfig() == null) {
            return false;
        }
        return other.getOutpostConfig() == null || other.getOutpostConfig().equals(this.getOutpostConfig());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getVersion() == null ? 0 : this.getVersion().hashCode());
        hashCode = 31 * hashCode + (this.getEndpoint() == null ? 0 : this.getEndpoint().hashCode());
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getResourcesVpcConfig() == null ? 0 : this.getResourcesVpcConfig().hashCode());
        hashCode = 31 * hashCode + (this.getKubernetesNetworkConfig() == null ? 0 : this.getKubernetesNetworkConfig().hashCode());
        hashCode = 31 * hashCode + (this.getLogging() == null ? 0 : this.getLogging().hashCode());
        hashCode = 31 * hashCode + (this.getIdentity() == null ? 0 : this.getIdentity().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getCertificateAuthority() == null ? 0 : this.getCertificateAuthority().hashCode());
        hashCode = 31 * hashCode + (this.getClientRequestToken() == null ? 0 : this.getClientRequestToken().hashCode());
        hashCode = 31 * hashCode + (this.getPlatformVersion() == null ? 0 : this.getPlatformVersion().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getEncryptionConfig() == null ? 0 : this.getEncryptionConfig().hashCode());
        hashCode = 31 * hashCode + (this.getConnectorConfig() == null ? 0 : this.getConnectorConfig().hashCode());
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getHealth() == null ? 0 : this.getHealth().hashCode());
        hashCode = 31 * hashCode + (this.getOutpostConfig() == null ? 0 : this.getOutpostConfig().hashCode());
        return hashCode;
    }

    public Cluster clone() {
        try {
            return (Cluster)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ClusterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

