/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eks.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.eks.model.transform.RemoteAccessConfigMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RemoteAccessConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String ec2SshKey;
    private List<String> sourceSecurityGroups;

    public void setEc2SshKey(String ec2SshKey) {
        this.ec2SshKey = ec2SshKey;
    }

    public String getEc2SshKey() {
        return this.ec2SshKey;
    }

    public RemoteAccessConfig withEc2SshKey(String ec2SshKey) {
        this.setEc2SshKey(ec2SshKey);
        return this;
    }

    public List<String> getSourceSecurityGroups() {
        return this.sourceSecurityGroups;
    }

    public void setSourceSecurityGroups(Collection<String> sourceSecurityGroups) {
        if (sourceSecurityGroups == null) {
            this.sourceSecurityGroups = null;
            return;
        }
        this.sourceSecurityGroups = new ArrayList<String>(sourceSecurityGroups);
    }

    public RemoteAccessConfig withSourceSecurityGroups(String ... sourceSecurityGroups) {
        if (this.sourceSecurityGroups == null) {
            this.setSourceSecurityGroups(new ArrayList<String>(sourceSecurityGroups.length));
        }
        for (String ele : sourceSecurityGroups) {
            this.sourceSecurityGroups.add(ele);
        }
        return this;
    }

    public RemoteAccessConfig withSourceSecurityGroups(Collection<String> sourceSecurityGroups) {
        this.setSourceSecurityGroups(sourceSecurityGroups);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEc2SshKey() != null) {
            sb.append("Ec2SshKey: ").append(this.getEc2SshKey()).append(",");
        }
        if (this.getSourceSecurityGroups() != null) {
            sb.append("SourceSecurityGroups: ").append(this.getSourceSecurityGroups());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoteAccessConfig)) {
            return false;
        }
        RemoteAccessConfig other = (RemoteAccessConfig)obj;
        if (other.getEc2SshKey() == null ^ this.getEc2SshKey() == null) {
            return false;
        }
        if (other.getEc2SshKey() != null && !other.getEc2SshKey().equals(this.getEc2SshKey())) {
            return false;
        }
        if (other.getSourceSecurityGroups() == null ^ this.getSourceSecurityGroups() == null) {
            return false;
        }
        return other.getSourceSecurityGroups() == null || other.getSourceSecurityGroups().equals(this.getSourceSecurityGroups());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEc2SshKey() == null ? 0 : this.getEc2SshKey().hashCode());
        hashCode = 31 * hashCode + (this.getSourceSecurityGroups() == null ? 0 : this.getSourceSecurityGroups().hashCode());
        return hashCode;
    }

    public RemoteAccessConfig clone() {
        try {
            return (RemoteAccessConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RemoteAccessConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

