/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticfilesystem.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.elasticfilesystem.model.Resource;
import com.amazonaws.services.elasticfilesystem.model.ResourceIdType;
import com.amazonaws.services.elasticfilesystem.model.transform.ResourceIdPreferenceMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ResourceIdPreference
implements Serializable,
Cloneable,
StructuredPojo {
    private String resourceIdType;
    private SdkInternalList<String> resources;

    public void setResourceIdType(String resourceIdType) {
        this.resourceIdType = resourceIdType;
    }

    public String getResourceIdType() {
        return this.resourceIdType;
    }

    public ResourceIdPreference withResourceIdType(String resourceIdType) {
        this.setResourceIdType(resourceIdType);
        return this;
    }

    public ResourceIdPreference withResourceIdType(ResourceIdType resourceIdType) {
        this.resourceIdType = resourceIdType.toString();
        return this;
    }

    public List<String> getResources() {
        if (this.resources == null) {
            this.resources = new SdkInternalList();
        }
        return this.resources;
    }

    public void setResources(Collection<String> resources) {
        if (resources == null) {
            this.resources = null;
            return;
        }
        this.resources = new SdkInternalList(resources);
    }

    public ResourceIdPreference withResources(String ... resources) {
        if (this.resources == null) {
            this.setResources((Collection<String>)new SdkInternalList(resources.length));
        }
        for (String ele : resources) {
            this.resources.add((Object)ele);
        }
        return this;
    }

    public ResourceIdPreference withResources(Collection<String> resources) {
        this.setResources(resources);
        return this;
    }

    public ResourceIdPreference withResources(Resource ... resources) {
        SdkInternalList resourcesCopy = new SdkInternalList(resources.length);
        for (Resource value : resources) {
            resourcesCopy.add((Object)value.toString());
        }
        if (this.getResources() == null) {
            this.setResources((Collection<String>)resourcesCopy);
        } else {
            this.getResources().addAll((Collection<String>)resourcesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceIdType() != null) {
            sb.append("ResourceIdType: ").append(this.getResourceIdType()).append(",");
        }
        if (this.getResources() != null) {
            sb.append("Resources: ").append(this.getResources());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceIdPreference)) {
            return false;
        }
        ResourceIdPreference other = (ResourceIdPreference)obj;
        if (other.getResourceIdType() == null ^ this.getResourceIdType() == null) {
            return false;
        }
        if (other.getResourceIdType() != null && !other.getResourceIdType().equals(this.getResourceIdType())) {
            return false;
        }
        if (other.getResources() == null ^ this.getResources() == null) {
            return false;
        }
        return other.getResources() == null || other.getResources().equals(this.getResources());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceIdType() == null ? 0 : this.getResourceIdType().hashCode());
        hashCode = 31 * hashCode + (this.getResources() == null ? 0 : this.getResources().hashCode());
        return hashCode;
    }

    public ResourceIdPreference clone() {
        try {
            return (ResourceIdPreference)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResourceIdPreferenceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

