/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ecr.model.ImageScanFinding;
import com.amazonaws.services.ecr.model.transform.ImageScanFindingsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ImageScanFindings
implements Serializable,
Cloneable,
StructuredPojo {
    private Date imageScanCompletedAt;
    private Date vulnerabilitySourceUpdatedAt;
    private List<ImageScanFinding> findings;
    private Map<String, Integer> findingSeverityCounts;

    public void setImageScanCompletedAt(Date imageScanCompletedAt) {
        this.imageScanCompletedAt = imageScanCompletedAt;
    }

    public Date getImageScanCompletedAt() {
        return this.imageScanCompletedAt;
    }

    public ImageScanFindings withImageScanCompletedAt(Date imageScanCompletedAt) {
        this.setImageScanCompletedAt(imageScanCompletedAt);
        return this;
    }

    public void setVulnerabilitySourceUpdatedAt(Date vulnerabilitySourceUpdatedAt) {
        this.vulnerabilitySourceUpdatedAt = vulnerabilitySourceUpdatedAt;
    }

    public Date getVulnerabilitySourceUpdatedAt() {
        return this.vulnerabilitySourceUpdatedAt;
    }

    public ImageScanFindings withVulnerabilitySourceUpdatedAt(Date vulnerabilitySourceUpdatedAt) {
        this.setVulnerabilitySourceUpdatedAt(vulnerabilitySourceUpdatedAt);
        return this;
    }

    public List<ImageScanFinding> getFindings() {
        return this.findings;
    }

    public void setFindings(Collection<ImageScanFinding> findings) {
        if (findings == null) {
            this.findings = null;
            return;
        }
        this.findings = new ArrayList<ImageScanFinding>(findings);
    }

    public ImageScanFindings withFindings(ImageScanFinding ... findings) {
        if (this.findings == null) {
            this.setFindings(new ArrayList<ImageScanFinding>(findings.length));
        }
        for (ImageScanFinding ele : findings) {
            this.findings.add(ele);
        }
        return this;
    }

    public ImageScanFindings withFindings(Collection<ImageScanFinding> findings) {
        this.setFindings(findings);
        return this;
    }

    public Map<String, Integer> getFindingSeverityCounts() {
        return this.findingSeverityCounts;
    }

    public void setFindingSeverityCounts(Map<String, Integer> findingSeverityCounts) {
        this.findingSeverityCounts = findingSeverityCounts;
    }

    public ImageScanFindings withFindingSeverityCounts(Map<String, Integer> findingSeverityCounts) {
        this.setFindingSeverityCounts(findingSeverityCounts);
        return this;
    }

    public ImageScanFindings addFindingSeverityCountsEntry(String key, Integer value) {
        if (null == this.findingSeverityCounts) {
            this.findingSeverityCounts = new HashMap<String, Integer>();
        }
        if (this.findingSeverityCounts.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.findingSeverityCounts.put(key, value);
        return this;
    }

    public ImageScanFindings clearFindingSeverityCountsEntries() {
        this.findingSeverityCounts = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getImageScanCompletedAt() != null) {
            sb.append("ImageScanCompletedAt: ").append(this.getImageScanCompletedAt()).append(",");
        }
        if (this.getVulnerabilitySourceUpdatedAt() != null) {
            sb.append("VulnerabilitySourceUpdatedAt: ").append(this.getVulnerabilitySourceUpdatedAt()).append(",");
        }
        if (this.getFindings() != null) {
            sb.append("Findings: ").append(this.getFindings()).append(",");
        }
        if (this.getFindingSeverityCounts() != null) {
            sb.append("FindingSeverityCounts: ").append(this.getFindingSeverityCounts());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageScanFindings)) {
            return false;
        }
        ImageScanFindings other = (ImageScanFindings)obj;
        if (other.getImageScanCompletedAt() == null ^ this.getImageScanCompletedAt() == null) {
            return false;
        }
        if (other.getImageScanCompletedAt() != null && !other.getImageScanCompletedAt().equals(this.getImageScanCompletedAt())) {
            return false;
        }
        if (other.getVulnerabilitySourceUpdatedAt() == null ^ this.getVulnerabilitySourceUpdatedAt() == null) {
            return false;
        }
        if (other.getVulnerabilitySourceUpdatedAt() != null && !other.getVulnerabilitySourceUpdatedAt().equals(this.getVulnerabilitySourceUpdatedAt())) {
            return false;
        }
        if (other.getFindings() == null ^ this.getFindings() == null) {
            return false;
        }
        if (other.getFindings() != null && !other.getFindings().equals(this.getFindings())) {
            return false;
        }
        if (other.getFindingSeverityCounts() == null ^ this.getFindingSeverityCounts() == null) {
            return false;
        }
        return other.getFindingSeverityCounts() == null || other.getFindingSeverityCounts().equals(this.getFindingSeverityCounts());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getImageScanCompletedAt() == null ? 0 : this.getImageScanCompletedAt().hashCode());
        hashCode = 31 * hashCode + (this.getVulnerabilitySourceUpdatedAt() == null ? 0 : this.getVulnerabilitySourceUpdatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getFindings() == null ? 0 : this.getFindings().hashCode());
        hashCode = 31 * hashCode + (this.getFindingSeverityCounts() == null ? 0 : this.getFindingSeverityCounts().hashCode());
        return hashCode;
    }

    public ImageScanFindings clone() {
        try {
            return (ImageScanFindings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ImageScanFindingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

