/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2instanceconnect;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.ec2instanceconnect.AWSEC2InstanceConnectAsync;
import com.amazonaws.services.ec2instanceconnect.AWSEC2InstanceConnectAsyncClientBuilder;
import com.amazonaws.services.ec2instanceconnect.AWSEC2InstanceConnectClient;
import com.amazonaws.services.ec2instanceconnect.model.SendSSHPublicKeyRequest;
import com.amazonaws.services.ec2instanceconnect.model.SendSSHPublicKeyResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSEC2InstanceConnectAsyncClient
extends AWSEC2InstanceConnectClient
implements AWSEC2InstanceConnectAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSEC2InstanceConnectAsyncClientBuilder asyncBuilder() {
        return AWSEC2InstanceConnectAsyncClientBuilder.standard();
    }

    AWSEC2InstanceConnectAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSEC2InstanceConnectAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<SendSSHPublicKeyResult> sendSSHPublicKeyAsync(SendSSHPublicKeyRequest request) {
        return this.sendSSHPublicKeyAsync(request, null);
    }

    @Override
    public Future<SendSSHPublicKeyResult> sendSSHPublicKeyAsync(SendSSHPublicKeyRequest request, final AsyncHandler<SendSSHPublicKeyRequest, SendSSHPublicKeyResult> asyncHandler) {
        final SendSSHPublicKeyRequest finalRequest = (SendSSHPublicKeyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SendSSHPublicKeyResult>(){

            @Override
            public SendSSHPublicKeyResult call() throws Exception {
                SendSSHPublicKeyResult result = null;
                try {
                    result = AWSEC2InstanceConnectAsyncClient.this.executeSendSSHPublicKey(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

