/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ec2.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * <p>
 * An Autonomous System Number (ASN) and BYOIP CIDR association.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AsnAssociation" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AsnAssociation implements Serializable, Cloneable {

    /**
     * <p>
     * The association's ASN.
     * </p>
     */
    private String asn;
    /**
     * <p>
     * The association's CIDR.
     * </p>
     */
    private String cidr;
    /**
     * <p>
     * The association's status message.
     * </p>
     */
    private String statusMessage;
    /**
     * <p>
     * The association's state.
     * </p>
     */
    private String state;

    /**
     * <p>
     * The association's ASN.
     * </p>
     * 
     * @param asn
     *        The association's ASN.
     */

    public void setAsn(String asn) {
        this.asn = asn;
    }

    /**
     * <p>
     * The association's ASN.
     * </p>
     * 
     * @return The association's ASN.
     */

    public String getAsn() {
        return this.asn;
    }

    /**
     * <p>
     * The association's ASN.
     * </p>
     * 
     * @param asn
     *        The association's ASN.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AsnAssociation withAsn(String asn) {
        setAsn(asn);
        return this;
    }

    /**
     * <p>
     * The association's CIDR.
     * </p>
     * 
     * @param cidr
     *        The association's CIDR.
     */

    public void setCidr(String cidr) {
        this.cidr = cidr;
    }

    /**
     * <p>
     * The association's CIDR.
     * </p>
     * 
     * @return The association's CIDR.
     */

    public String getCidr() {
        return this.cidr;
    }

    /**
     * <p>
     * The association's CIDR.
     * </p>
     * 
     * @param cidr
     *        The association's CIDR.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AsnAssociation withCidr(String cidr) {
        setCidr(cidr);
        return this;
    }

    /**
     * <p>
     * The association's status message.
     * </p>
     * 
     * @param statusMessage
     *        The association's status message.
     */

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    /**
     * <p>
     * The association's status message.
     * </p>
     * 
     * @return The association's status message.
     */

    public String getStatusMessage() {
        return this.statusMessage;
    }

    /**
     * <p>
     * The association's status message.
     * </p>
     * 
     * @param statusMessage
     *        The association's status message.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AsnAssociation withStatusMessage(String statusMessage) {
        setStatusMessage(statusMessage);
        return this;
    }

    /**
     * <p>
     * The association's state.
     * </p>
     * 
     * @param state
     *        The association's state.
     * @see AsnAssociationState
     */

    public void setState(String state) {
        this.state = state;
    }

    /**
     * <p>
     * The association's state.
     * </p>
     * 
     * @return The association's state.
     * @see AsnAssociationState
     */

    public String getState() {
        return this.state;
    }

    /**
     * <p>
     * The association's state.
     * </p>
     * 
     * @param state
     *        The association's state.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see AsnAssociationState
     */

    public AsnAssociation withState(String state) {
        setState(state);
        return this;
    }

    /**
     * <p>
     * The association's state.
     * </p>
     * 
     * @param state
     *        The association's state.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see AsnAssociationState
     */

    public AsnAssociation withState(AsnAssociationState state) {
        this.state = state.toString();
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAsn() != null)
            sb.append("Asn: ").append(getAsn()).append(",");
        if (getCidr() != null)
            sb.append("Cidr: ").append(getCidr()).append(",");
        if (getStatusMessage() != null)
            sb.append("StatusMessage: ").append(getStatusMessage()).append(",");
        if (getState() != null)
            sb.append("State: ").append(getState());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof AsnAssociation == false)
            return false;
        AsnAssociation other = (AsnAssociation) obj;
        if (other.getAsn() == null ^ this.getAsn() == null)
            return false;
        if (other.getAsn() != null && other.getAsn().equals(this.getAsn()) == false)
            return false;
        if (other.getCidr() == null ^ this.getCidr() == null)
            return false;
        if (other.getCidr() != null && other.getCidr().equals(this.getCidr()) == false)
            return false;
        if (other.getStatusMessage() == null ^ this.getStatusMessage() == null)
            return false;
        if (other.getStatusMessage() != null && other.getStatusMessage().equals(this.getStatusMessage()) == false)
            return false;
        if (other.getState() == null ^ this.getState() == null)
            return false;
        if (other.getState() != null && other.getState().equals(this.getState()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAsn() == null) ? 0 : getAsn().hashCode());
        hashCode = prime * hashCode + ((getCidr() == null) ? 0 : getCidr().hashCode());
        hashCode = prime * hashCode + ((getStatusMessage() == null) ? 0 : getStatusMessage().hashCode());
        hashCode = prime * hashCode + ((getState() == null) ? 0 : getState().hashCode());
        return hashCode;
    }

    @Override
    public AsnAssociation clone() {
        try {
            return (AsnAssociation) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
