/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.BlockDeviceMapping;
import com.amazonaws.services.ec2.model.LaunchPermission;
import com.amazonaws.services.ec2.model.ProductCode;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ImageAttribute
implements Serializable,
Cloneable {
    private SdkInternalList<BlockDeviceMapping> blockDeviceMappings;
    private String imageId;
    private SdkInternalList<LaunchPermission> launchPermissions;
    private SdkInternalList<ProductCode> productCodes;
    private String description;
    private String kernelId;
    private String ramdiskId;
    private String sriovNetSupport;
    private String bootMode;
    private String tpmSupport;
    private String uefiData;
    private String lastLaunchedTime;
    private String imdsSupport;
    private String deregistrationProtection;

    public List<BlockDeviceMapping> getBlockDeviceMappings() {
        if (this.blockDeviceMappings == null) {
            this.blockDeviceMappings = new SdkInternalList();
        }
        return this.blockDeviceMappings;
    }

    public void setBlockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
        if (blockDeviceMappings == null) {
            this.blockDeviceMappings = null;
            return;
        }
        this.blockDeviceMappings = new SdkInternalList(blockDeviceMappings);
    }

    public ImageAttribute withBlockDeviceMappings(BlockDeviceMapping ... blockDeviceMappings) {
        if (this.blockDeviceMappings == null) {
            this.setBlockDeviceMappings((Collection<BlockDeviceMapping>)new SdkInternalList(blockDeviceMappings.length));
        }
        for (BlockDeviceMapping ele : blockDeviceMappings) {
            this.blockDeviceMappings.add((Object)ele);
        }
        return this;
    }

    public ImageAttribute withBlockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
        this.setBlockDeviceMappings(blockDeviceMappings);
        return this;
    }

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    public String getImageId() {
        return this.imageId;
    }

    public ImageAttribute withImageId(String imageId) {
        this.setImageId(imageId);
        return this;
    }

    public List<LaunchPermission> getLaunchPermissions() {
        if (this.launchPermissions == null) {
            this.launchPermissions = new SdkInternalList();
        }
        return this.launchPermissions;
    }

    public void setLaunchPermissions(Collection<LaunchPermission> launchPermissions) {
        if (launchPermissions == null) {
            this.launchPermissions = null;
            return;
        }
        this.launchPermissions = new SdkInternalList(launchPermissions);
    }

    public ImageAttribute withLaunchPermissions(LaunchPermission ... launchPermissions) {
        if (this.launchPermissions == null) {
            this.setLaunchPermissions((Collection<LaunchPermission>)new SdkInternalList(launchPermissions.length));
        }
        for (LaunchPermission ele : launchPermissions) {
            this.launchPermissions.add((Object)ele);
        }
        return this;
    }

    public ImageAttribute withLaunchPermissions(Collection<LaunchPermission> launchPermissions) {
        this.setLaunchPermissions(launchPermissions);
        return this;
    }

    public List<ProductCode> getProductCodes() {
        if (this.productCodes == null) {
            this.productCodes = new SdkInternalList();
        }
        return this.productCodes;
    }

    public void setProductCodes(Collection<ProductCode> productCodes) {
        if (productCodes == null) {
            this.productCodes = null;
            return;
        }
        this.productCodes = new SdkInternalList(productCodes);
    }

    public ImageAttribute withProductCodes(ProductCode ... productCodes) {
        if (this.productCodes == null) {
            this.setProductCodes((Collection<ProductCode>)new SdkInternalList(productCodes.length));
        }
        for (ProductCode ele : productCodes) {
            this.productCodes.add((Object)ele);
        }
        return this;
    }

    public ImageAttribute withProductCodes(Collection<ProductCode> productCodes) {
        this.setProductCodes(productCodes);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public ImageAttribute withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setKernelId(String kernelId) {
        this.kernelId = kernelId;
    }

    public String getKernelId() {
        return this.kernelId;
    }

    public ImageAttribute withKernelId(String kernelId) {
        this.setKernelId(kernelId);
        return this;
    }

    public void setRamdiskId(String ramdiskId) {
        this.ramdiskId = ramdiskId;
    }

    public String getRamdiskId() {
        return this.ramdiskId;
    }

    public ImageAttribute withRamdiskId(String ramdiskId) {
        this.setRamdiskId(ramdiskId);
        return this;
    }

    public void setSriovNetSupport(String sriovNetSupport) {
        this.sriovNetSupport = sriovNetSupport;
    }

    public String getSriovNetSupport() {
        return this.sriovNetSupport;
    }

    public ImageAttribute withSriovNetSupport(String sriovNetSupport) {
        this.setSriovNetSupport(sriovNetSupport);
        return this;
    }

    public void setBootMode(String bootMode) {
        this.bootMode = bootMode;
    }

    public String getBootMode() {
        return this.bootMode;
    }

    public ImageAttribute withBootMode(String bootMode) {
        this.setBootMode(bootMode);
        return this;
    }

    public void setTpmSupport(String tpmSupport) {
        this.tpmSupport = tpmSupport;
    }

    public String getTpmSupport() {
        return this.tpmSupport;
    }

    public ImageAttribute withTpmSupport(String tpmSupport) {
        this.setTpmSupport(tpmSupport);
        return this;
    }

    public void setUefiData(String uefiData) {
        this.uefiData = uefiData;
    }

    public String getUefiData() {
        return this.uefiData;
    }

    public ImageAttribute withUefiData(String uefiData) {
        this.setUefiData(uefiData);
        return this;
    }

    public void setLastLaunchedTime(String lastLaunchedTime) {
        this.lastLaunchedTime = lastLaunchedTime;
    }

    public String getLastLaunchedTime() {
        return this.lastLaunchedTime;
    }

    public ImageAttribute withLastLaunchedTime(String lastLaunchedTime) {
        this.setLastLaunchedTime(lastLaunchedTime);
        return this;
    }

    public void setImdsSupport(String imdsSupport) {
        this.imdsSupport = imdsSupport;
    }

    public String getImdsSupport() {
        return this.imdsSupport;
    }

    public ImageAttribute withImdsSupport(String imdsSupport) {
        this.setImdsSupport(imdsSupport);
        return this;
    }

    public void setDeregistrationProtection(String deregistrationProtection) {
        this.deregistrationProtection = deregistrationProtection;
    }

    public String getDeregistrationProtection() {
        return this.deregistrationProtection;
    }

    public ImageAttribute withDeregistrationProtection(String deregistrationProtection) {
        this.setDeregistrationProtection(deregistrationProtection);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBlockDeviceMappings() != null) {
            sb.append("BlockDeviceMappings: ").append(this.getBlockDeviceMappings()).append(",");
        }
        if (this.getImageId() != null) {
            sb.append("ImageId: ").append(this.getImageId()).append(",");
        }
        if (this.getLaunchPermissions() != null) {
            sb.append("LaunchPermissions: ").append(this.getLaunchPermissions()).append(",");
        }
        if (this.getProductCodes() != null) {
            sb.append("ProductCodes: ").append(this.getProductCodes()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getKernelId() != null) {
            sb.append("KernelId: ").append(this.getKernelId()).append(",");
        }
        if (this.getRamdiskId() != null) {
            sb.append("RamdiskId: ").append(this.getRamdiskId()).append(",");
        }
        if (this.getSriovNetSupport() != null) {
            sb.append("SriovNetSupport: ").append(this.getSriovNetSupport()).append(",");
        }
        if (this.getBootMode() != null) {
            sb.append("BootMode: ").append(this.getBootMode()).append(",");
        }
        if (this.getTpmSupport() != null) {
            sb.append("TpmSupport: ").append(this.getTpmSupport()).append(",");
        }
        if (this.getUefiData() != null) {
            sb.append("UefiData: ").append(this.getUefiData()).append(",");
        }
        if (this.getLastLaunchedTime() != null) {
            sb.append("LastLaunchedTime: ").append(this.getLastLaunchedTime()).append(",");
        }
        if (this.getImdsSupport() != null) {
            sb.append("ImdsSupport: ").append(this.getImdsSupport()).append(",");
        }
        if (this.getDeregistrationProtection() != null) {
            sb.append("DeregistrationProtection: ").append(this.getDeregistrationProtection());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageAttribute)) {
            return false;
        }
        ImageAttribute other = (ImageAttribute)obj;
        if (other.getBlockDeviceMappings() == null ^ this.getBlockDeviceMappings() == null) {
            return false;
        }
        if (other.getBlockDeviceMappings() != null && !other.getBlockDeviceMappings().equals(this.getBlockDeviceMappings())) {
            return false;
        }
        if (other.getImageId() == null ^ this.getImageId() == null) {
            return false;
        }
        if (other.getImageId() != null && !other.getImageId().equals(this.getImageId())) {
            return false;
        }
        if (other.getLaunchPermissions() == null ^ this.getLaunchPermissions() == null) {
            return false;
        }
        if (other.getLaunchPermissions() != null && !other.getLaunchPermissions().equals(this.getLaunchPermissions())) {
            return false;
        }
        if (other.getProductCodes() == null ^ this.getProductCodes() == null) {
            return false;
        }
        if (other.getProductCodes() != null && !other.getProductCodes().equals(this.getProductCodes())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getKernelId() == null ^ this.getKernelId() == null) {
            return false;
        }
        if (other.getKernelId() != null && !other.getKernelId().equals(this.getKernelId())) {
            return false;
        }
        if (other.getRamdiskId() == null ^ this.getRamdiskId() == null) {
            return false;
        }
        if (other.getRamdiskId() != null && !other.getRamdiskId().equals(this.getRamdiskId())) {
            return false;
        }
        if (other.getSriovNetSupport() == null ^ this.getSriovNetSupport() == null) {
            return false;
        }
        if (other.getSriovNetSupport() != null && !other.getSriovNetSupport().equals(this.getSriovNetSupport())) {
            return false;
        }
        if (other.getBootMode() == null ^ this.getBootMode() == null) {
            return false;
        }
        if (other.getBootMode() != null && !other.getBootMode().equals(this.getBootMode())) {
            return false;
        }
        if (other.getTpmSupport() == null ^ this.getTpmSupport() == null) {
            return false;
        }
        if (other.getTpmSupport() != null && !other.getTpmSupport().equals(this.getTpmSupport())) {
            return false;
        }
        if (other.getUefiData() == null ^ this.getUefiData() == null) {
            return false;
        }
        if (other.getUefiData() != null && !other.getUefiData().equals(this.getUefiData())) {
            return false;
        }
        if (other.getLastLaunchedTime() == null ^ this.getLastLaunchedTime() == null) {
            return false;
        }
        if (other.getLastLaunchedTime() != null && !other.getLastLaunchedTime().equals(this.getLastLaunchedTime())) {
            return false;
        }
        if (other.getImdsSupport() == null ^ this.getImdsSupport() == null) {
            return false;
        }
        if (other.getImdsSupport() != null && !other.getImdsSupport().equals(this.getImdsSupport())) {
            return false;
        }
        if (other.getDeregistrationProtection() == null ^ this.getDeregistrationProtection() == null) {
            return false;
        }
        return other.getDeregistrationProtection() == null || other.getDeregistrationProtection().equals(this.getDeregistrationProtection());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBlockDeviceMappings() == null ? 0 : this.getBlockDeviceMappings().hashCode());
        hashCode = 31 * hashCode + (this.getImageId() == null ? 0 : this.getImageId().hashCode());
        hashCode = 31 * hashCode + (this.getLaunchPermissions() == null ? 0 : this.getLaunchPermissions().hashCode());
        hashCode = 31 * hashCode + (this.getProductCodes() == null ? 0 : this.getProductCodes().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getKernelId() == null ? 0 : this.getKernelId().hashCode());
        hashCode = 31 * hashCode + (this.getRamdiskId() == null ? 0 : this.getRamdiskId().hashCode());
        hashCode = 31 * hashCode + (this.getSriovNetSupport() == null ? 0 : this.getSriovNetSupport().hashCode());
        hashCode = 31 * hashCode + (this.getBootMode() == null ? 0 : this.getBootMode().hashCode());
        hashCode = 31 * hashCode + (this.getTpmSupport() == null ? 0 : this.getTpmSupport().hashCode());
        hashCode = 31 * hashCode + (this.getUefiData() == null ? 0 : this.getUefiData().hashCode());
        hashCode = 31 * hashCode + (this.getLastLaunchedTime() == null ? 0 : this.getLastLaunchedTime().hashCode());
        hashCode = 31 * hashCode + (this.getImdsSupport() == null ? 0 : this.getImdsSupport().hashCode());
        hashCode = 31 * hashCode + (this.getDeregistrationProtection() == null ? 0 : this.getDeregistrationProtection().hashCode());
        return hashCode;
    }

    public ImageAttribute clone() {
        try {
            return (ImageAttribute)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

