/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeIpamPoolsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeIpamPoolsRequestMarshaller
implements Marshaller<Request<DescribeIpamPoolsRequest>, DescribeIpamPoolsRequest> {
    public Request<DescribeIpamPoolsRequest> marshall(DescribeIpamPoolsRequest describeIpamPoolsRequest) {
        SdkInternalList describeIpamPoolsRequestIpamPoolIdsList;
        if (describeIpamPoolsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeIpamPoolsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeIpamPools");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeIpamPoolsRequestFiltersList = (SdkInternalList)describeIpamPoolsRequest.getFilters();
        if (!describeIpamPoolsRequestFiltersList.isEmpty() || !describeIpamPoolsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeIpamPoolsRequestFiltersListValue : describeIpamPoolsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeIpamPoolsRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeIpamPoolsRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeIpamPoolsRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeIpamPoolsRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeIpamPoolsRequest.getMaxResults()));
        }
        if (describeIpamPoolsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeIpamPoolsRequest.getNextToken()));
        }
        if (!(describeIpamPoolsRequestIpamPoolIdsList = (SdkInternalList)describeIpamPoolsRequest.getIpamPoolIds()).isEmpty() || !describeIpamPoolsRequestIpamPoolIdsList.isAutoConstruct()) {
            int ipamPoolIdsListIndex = 1;
            for (String describeIpamPoolsRequestIpamPoolIdsListValue : describeIpamPoolsRequestIpamPoolIdsList) {
                if (describeIpamPoolsRequestIpamPoolIdsListValue != null) {
                    request.addParameter("IpamPoolId." + ipamPoolIdsListIndex, StringUtils.fromString((String)describeIpamPoolsRequestIpamPoolIdsListValue));
                }
                ++ipamPoolIdsListIndex;
            }
        }
        return request;
    }
}

