/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ec2.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * <p>
 * Provides authorization for Amazon to bring an Autonomous System Number (ASN) to a specific Amazon Web Services
 * account using bring your own ASN (BYOASN). For details on the format of the message and signature, see <a
 * href="https://docs.aws.amazon.com/vpc/latest/ipam/tutorials-byoasn.html">Tutorial: Bring your ASN to IPAM</a> in the
 * <i>Amazon VPC IPAM guide</i>.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AsnAuthorizationContext" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AsnAuthorizationContext implements Serializable, Cloneable {

    /**
     * <p>
     * The authorization context's message.
     * </p>
     */
    private String message;
    /**
     * <p>
     * The authorization context's signature.
     * </p>
     */
    private String signature;

    /**
     * <p>
     * The authorization context's message.
     * </p>
     * 
     * @param message
     *        The authorization context's message.
     */

    public void setMessage(String message) {
        this.message = message;
    }

    /**
     * <p>
     * The authorization context's message.
     * </p>
     * 
     * @return The authorization context's message.
     */

    public String getMessage() {
        return this.message;
    }

    /**
     * <p>
     * The authorization context's message.
     * </p>
     * 
     * @param message
     *        The authorization context's message.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AsnAuthorizationContext withMessage(String message) {
        setMessage(message);
        return this;
    }

    /**
     * <p>
     * The authorization context's signature.
     * </p>
     * 
     * @param signature
     *        The authorization context's signature.
     */

    public void setSignature(String signature) {
        this.signature = signature;
    }

    /**
     * <p>
     * The authorization context's signature.
     * </p>
     * 
     * @return The authorization context's signature.
     */

    public String getSignature() {
        return this.signature;
    }

    /**
     * <p>
     * The authorization context's signature.
     * </p>
     * 
     * @param signature
     *        The authorization context's signature.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AsnAuthorizationContext withSignature(String signature) {
        setSignature(signature);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getMessage() != null)
            sb.append("Message: ").append(getMessage()).append(",");
        if (getSignature() != null)
            sb.append("Signature: ").append(getSignature());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof AsnAuthorizationContext == false)
            return false;
        AsnAuthorizationContext other = (AsnAuthorizationContext) obj;
        if (other.getMessage() == null ^ this.getMessage() == null)
            return false;
        if (other.getMessage() != null && other.getMessage().equals(this.getMessage()) == false)
            return false;
        if (other.getSignature() == null ^ this.getSignature() == null)
            return false;
        if (other.getSignature() != null && other.getSignature().equals(this.getSignature()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getMessage() == null) ? 0 : getMessage().hashCode());
        hashCode = prime * hashCode + ((getSignature() == null) ? 0 : getSignature().hashCode());
        return hashCode;
    }

    @Override
    public AsnAuthorizationContext clone() {
        try {
            return (AsnAuthorizationContext) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
