/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeInstanceTopologyRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeInstanceTopologyRequestMarshaller
implements Marshaller<Request<DescribeInstanceTopologyRequest>, DescribeInstanceTopologyRequest> {
    public Request<DescribeInstanceTopologyRequest> marshall(DescribeInstanceTopologyRequest describeInstanceTopologyRequest) {
        SdkInternalList describeInstanceTopologyRequestFiltersList;
        SdkInternalList describeInstanceTopologyRequestGroupNamesList;
        SdkInternalList describeInstanceTopologyRequestInstanceIdsList;
        if (describeInstanceTopologyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeInstanceTopologyRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeInstanceTopology");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeInstanceTopologyRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeInstanceTopologyRequest.getNextToken()));
        }
        if (describeInstanceTopologyRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeInstanceTopologyRequest.getMaxResults()));
        }
        if (!(describeInstanceTopologyRequestInstanceIdsList = (SdkInternalList)describeInstanceTopologyRequest.getInstanceIds()).isEmpty() || !describeInstanceTopologyRequestInstanceIdsList.isAutoConstruct()) {
            int instanceIdsListIndex = 1;
            for (Object describeInstanceTopologyRequestInstanceIdsListValue : describeInstanceTopologyRequestInstanceIdsList) {
                if (describeInstanceTopologyRequestInstanceIdsListValue != null) {
                    request.addParameter("InstanceId." + instanceIdsListIndex, StringUtils.fromString((String)describeInstanceTopologyRequestInstanceIdsListValue));
                }
                ++instanceIdsListIndex;
            }
        }
        if (!(describeInstanceTopologyRequestGroupNamesList = (SdkInternalList)describeInstanceTopologyRequest.getGroupNames()).isEmpty() || !describeInstanceTopologyRequestGroupNamesList.isAutoConstruct()) {
            int groupNamesListIndex = 1;
            for (String describeInstanceTopologyRequestGroupNamesListValue : describeInstanceTopologyRequestGroupNamesList) {
                if (describeInstanceTopologyRequestGroupNamesListValue != null) {
                    request.addParameter("GroupName." + groupNamesListIndex, StringUtils.fromString((String)describeInstanceTopologyRequestGroupNamesListValue));
                }
                ++groupNamesListIndex;
            }
        }
        if (!(describeInstanceTopologyRequestFiltersList = (SdkInternalList)describeInstanceTopologyRequest.getFilters()).isEmpty() || !describeInstanceTopologyRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeInstanceTopologyRequestFiltersListValue : describeInstanceTopologyRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeInstanceTopologyRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeInstanceTopologyRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeInstanceTopologyRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        return request;
    }
}

