/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ec2.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * <p>
 * Describes the options for an Amazon Web Services Verified Access device-identity based trust provider.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeviceOptions" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DeviceOptions implements Serializable, Cloneable {

    /**
     * <p>
     * The ID of the tenant application with the device-identity provider.
     * </p>
     */
    private String tenantId;
    /**
     * <p>
     * The URL Amazon Web Services Verified Access will use to verify the authenticity of the device tokens.
     * </p>
     */
    private String publicSigningKeyUrl;

    /**
     * <p>
     * The ID of the tenant application with the device-identity provider.
     * </p>
     * 
     * @param tenantId
     *        The ID of the tenant application with the device-identity provider.
     */

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    /**
     * <p>
     * The ID of the tenant application with the device-identity provider.
     * </p>
     * 
     * @return The ID of the tenant application with the device-identity provider.
     */

    public String getTenantId() {
        return this.tenantId;
    }

    /**
     * <p>
     * The ID of the tenant application with the device-identity provider.
     * </p>
     * 
     * @param tenantId
     *        The ID of the tenant application with the device-identity provider.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DeviceOptions withTenantId(String tenantId) {
        setTenantId(tenantId);
        return this;
    }

    /**
     * <p>
     * The URL Amazon Web Services Verified Access will use to verify the authenticity of the device tokens.
     * </p>
     * 
     * @param publicSigningKeyUrl
     *        The URL Amazon Web Services Verified Access will use to verify the authenticity of the device tokens.
     */

    public void setPublicSigningKeyUrl(String publicSigningKeyUrl) {
        this.publicSigningKeyUrl = publicSigningKeyUrl;
    }

    /**
     * <p>
     * The URL Amazon Web Services Verified Access will use to verify the authenticity of the device tokens.
     * </p>
     * 
     * @return The URL Amazon Web Services Verified Access will use to verify the authenticity of the device tokens.
     */

    public String getPublicSigningKeyUrl() {
        return this.publicSigningKeyUrl;
    }

    /**
     * <p>
     * The URL Amazon Web Services Verified Access will use to verify the authenticity of the device tokens.
     * </p>
     * 
     * @param publicSigningKeyUrl
     *        The URL Amazon Web Services Verified Access will use to verify the authenticity of the device tokens.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DeviceOptions withPublicSigningKeyUrl(String publicSigningKeyUrl) {
        setPublicSigningKeyUrl(publicSigningKeyUrl);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getTenantId() != null)
            sb.append("TenantId: ").append(getTenantId()).append(",");
        if (getPublicSigningKeyUrl() != null)
            sb.append("PublicSigningKeyUrl: ").append(getPublicSigningKeyUrl());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DeviceOptions == false)
            return false;
        DeviceOptions other = (DeviceOptions) obj;
        if (other.getTenantId() == null ^ this.getTenantId() == null)
            return false;
        if (other.getTenantId() != null && other.getTenantId().equals(this.getTenantId()) == false)
            return false;
        if (other.getPublicSigningKeyUrl() == null ^ this.getPublicSigningKeyUrl() == null)
            return false;
        if (other.getPublicSigningKeyUrl() != null && other.getPublicSigningKeyUrl().equals(this.getPublicSigningKeyUrl()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getTenantId() == null) ? 0 : getTenantId().hashCode());
        hashCode = prime * hashCode + ((getPublicSigningKeyUrl() == null) ? 0 : getPublicSigningKeyUrl().hashCode());
        return hashCode;
    }

    @Override
    public DeviceOptions clone() {
        try {
            return (DeviceOptions) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
