/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CreateReplaceRootVolumeTaskRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.IdempotentUtils;
import com.amazonaws.util.StringUtils;

public class CreateReplaceRootVolumeTaskRequestMarshaller
implements Marshaller<Request<CreateReplaceRootVolumeTaskRequest>, CreateReplaceRootVolumeTaskRequest> {
    public Request<CreateReplaceRootVolumeTaskRequest> marshall(CreateReplaceRootVolumeTaskRequest createReplaceRootVolumeTaskRequest) {
        if (createReplaceRootVolumeTaskRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createReplaceRootVolumeTaskRequest, "AmazonEC2");
        request.addParameter("Action", "CreateReplaceRootVolumeTask");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createReplaceRootVolumeTaskRequest.getInstanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString((String)createReplaceRootVolumeTaskRequest.getInstanceId()));
        }
        if (createReplaceRootVolumeTaskRequest.getSnapshotId() != null) {
            request.addParameter("SnapshotId", StringUtils.fromString((String)createReplaceRootVolumeTaskRequest.getSnapshotId()));
        }
        request.addParameter("ClientToken", IdempotentUtils.resolveString((String)createReplaceRootVolumeTaskRequest.getClientToken()));
        SdkInternalList createReplaceRootVolumeTaskRequestTagSpecificationsList = (SdkInternalList)createReplaceRootVolumeTaskRequest.getTagSpecifications();
        if (!createReplaceRootVolumeTaskRequestTagSpecificationsList.isEmpty() || !createReplaceRootVolumeTaskRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createReplaceRootVolumeTaskRequestTagSpecificationsListValue : createReplaceRootVolumeTaskRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createReplaceRootVolumeTaskRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString((String)createReplaceRootVolumeTaskRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createReplaceRootVolumeTaskRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        if (createReplaceRootVolumeTaskRequest.getImageId() != null) {
            request.addParameter("ImageId", StringUtils.fromString((String)createReplaceRootVolumeTaskRequest.getImageId()));
        }
        if (createReplaceRootVolumeTaskRequest.getDeleteReplacedRootVolume() != null) {
            request.addParameter("DeleteReplacedRootVolume", StringUtils.fromBoolean((Boolean)createReplaceRootVolumeTaskRequest.getDeleteReplacedRootVolume()));
        }
        return request;
    }
}

