/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DiskInfo;
import com.amazonaws.services.ec2.model.EphemeralNvmeSupport;
import com.amazonaws.services.ec2.model.InstanceStorageEncryptionSupport;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class InstanceStorageInfo
implements Serializable,
Cloneable {
    private Long totalSizeInGB;
    private SdkInternalList<DiskInfo> disks;
    private String nvmeSupport;
    private String encryptionSupport;

    public void setTotalSizeInGB(Long totalSizeInGB) {
        this.totalSizeInGB = totalSizeInGB;
    }

    public Long getTotalSizeInGB() {
        return this.totalSizeInGB;
    }

    public InstanceStorageInfo withTotalSizeInGB(Long totalSizeInGB) {
        this.setTotalSizeInGB(totalSizeInGB);
        return this;
    }

    public List<DiskInfo> getDisks() {
        if (this.disks == null) {
            this.disks = new SdkInternalList();
        }
        return this.disks;
    }

    public void setDisks(Collection<DiskInfo> disks) {
        if (disks == null) {
            this.disks = null;
            return;
        }
        this.disks = new SdkInternalList(disks);
    }

    public InstanceStorageInfo withDisks(DiskInfo ... disks) {
        if (this.disks == null) {
            this.setDisks((Collection<DiskInfo>)new SdkInternalList(disks.length));
        }
        for (DiskInfo ele : disks) {
            this.disks.add((Object)ele);
        }
        return this;
    }

    public InstanceStorageInfo withDisks(Collection<DiskInfo> disks) {
        this.setDisks(disks);
        return this;
    }

    public void setNvmeSupport(String nvmeSupport) {
        this.nvmeSupport = nvmeSupport;
    }

    public String getNvmeSupport() {
        return this.nvmeSupport;
    }

    public InstanceStorageInfo withNvmeSupport(String nvmeSupport) {
        this.setNvmeSupport(nvmeSupport);
        return this;
    }

    public InstanceStorageInfo withNvmeSupport(EphemeralNvmeSupport nvmeSupport) {
        this.nvmeSupport = nvmeSupport.toString();
        return this;
    }

    public void setEncryptionSupport(String encryptionSupport) {
        this.encryptionSupport = encryptionSupport;
    }

    public String getEncryptionSupport() {
        return this.encryptionSupport;
    }

    public InstanceStorageInfo withEncryptionSupport(String encryptionSupport) {
        this.setEncryptionSupport(encryptionSupport);
        return this;
    }

    public InstanceStorageInfo withEncryptionSupport(InstanceStorageEncryptionSupport encryptionSupport) {
        this.encryptionSupport = encryptionSupport.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTotalSizeInGB() != null) {
            sb.append("TotalSizeInGB: ").append(this.getTotalSizeInGB()).append(",");
        }
        if (this.getDisks() != null) {
            sb.append("Disks: ").append(this.getDisks()).append(",");
        }
        if (this.getNvmeSupport() != null) {
            sb.append("NvmeSupport: ").append(this.getNvmeSupport()).append(",");
        }
        if (this.getEncryptionSupport() != null) {
            sb.append("EncryptionSupport: ").append(this.getEncryptionSupport());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceStorageInfo)) {
            return false;
        }
        InstanceStorageInfo other = (InstanceStorageInfo)obj;
        if (other.getTotalSizeInGB() == null ^ this.getTotalSizeInGB() == null) {
            return false;
        }
        if (other.getTotalSizeInGB() != null && !other.getTotalSizeInGB().equals(this.getTotalSizeInGB())) {
            return false;
        }
        if (other.getDisks() == null ^ this.getDisks() == null) {
            return false;
        }
        if (other.getDisks() != null && !other.getDisks().equals(this.getDisks())) {
            return false;
        }
        if (other.getNvmeSupport() == null ^ this.getNvmeSupport() == null) {
            return false;
        }
        if (other.getNvmeSupport() != null && !other.getNvmeSupport().equals(this.getNvmeSupport())) {
            return false;
        }
        if (other.getEncryptionSupport() == null ^ this.getEncryptionSupport() == null) {
            return false;
        }
        return other.getEncryptionSupport() == null || other.getEncryptionSupport().equals(this.getEncryptionSupport());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTotalSizeInGB() == null ? 0 : this.getTotalSizeInGB().hashCode());
        hashCode = 31 * hashCode + (this.getDisks() == null ? 0 : this.getDisks().hashCode());
        hashCode = 31 * hashCode + (this.getNvmeSupport() == null ? 0 : this.getNvmeSupport().hashCode());
        hashCode = 31 * hashCode + (this.getEncryptionSupport() == null ? 0 : this.getEncryptionSupport().hashCode());
        return hashCode;
    }

    public InstanceStorageInfo clone() {
        try {
            return (InstanceStorageInfo)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

