/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DomainType;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.services.ec2.model.transform.AllocateAddressRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class AllocateAddressRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<AllocateAddressRequest> {
    private String domain;
    private String address;
    private String publicIpv4Pool;
    private String networkBorderGroup;
    private String customerOwnedIpv4Pool;
    private SdkInternalList<TagSpecification> tagSpecifications;

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getDomain() {
        return this.domain;
    }

    public AllocateAddressRequest withDomain(String domain) {
        this.setDomain(domain);
        return this;
    }

    public void setDomain(DomainType domain) {
        this.withDomain(domain);
    }

    public AllocateAddressRequest withDomain(DomainType domain) {
        this.domain = domain.toString();
        return this;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getAddress() {
        return this.address;
    }

    public AllocateAddressRequest withAddress(String address) {
        this.setAddress(address);
        return this;
    }

    public void setPublicIpv4Pool(String publicIpv4Pool) {
        this.publicIpv4Pool = publicIpv4Pool;
    }

    public String getPublicIpv4Pool() {
        return this.publicIpv4Pool;
    }

    public AllocateAddressRequest withPublicIpv4Pool(String publicIpv4Pool) {
        this.setPublicIpv4Pool(publicIpv4Pool);
        return this;
    }

    public void setNetworkBorderGroup(String networkBorderGroup) {
        this.networkBorderGroup = networkBorderGroup;
    }

    public String getNetworkBorderGroup() {
        return this.networkBorderGroup;
    }

    public AllocateAddressRequest withNetworkBorderGroup(String networkBorderGroup) {
        this.setNetworkBorderGroup(networkBorderGroup);
        return this;
    }

    public void setCustomerOwnedIpv4Pool(String customerOwnedIpv4Pool) {
        this.customerOwnedIpv4Pool = customerOwnedIpv4Pool;
    }

    public String getCustomerOwnedIpv4Pool() {
        return this.customerOwnedIpv4Pool;
    }

    public AllocateAddressRequest withCustomerOwnedIpv4Pool(String customerOwnedIpv4Pool) {
        this.setCustomerOwnedIpv4Pool(customerOwnedIpv4Pool);
        return this;
    }

    public List<TagSpecification> getTagSpecifications() {
        if (this.tagSpecifications == null) {
            this.tagSpecifications = new SdkInternalList();
        }
        return this.tagSpecifications;
    }

    public void setTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        if (tagSpecifications == null) {
            this.tagSpecifications = null;
            return;
        }
        this.tagSpecifications = new SdkInternalList(tagSpecifications);
    }

    public AllocateAddressRequest withTagSpecifications(TagSpecification ... tagSpecifications) {
        if (this.tagSpecifications == null) {
            this.setTagSpecifications((Collection<TagSpecification>)new SdkInternalList(tagSpecifications.length));
        }
        for (TagSpecification ele : tagSpecifications) {
            this.tagSpecifications.add((Object)ele);
        }
        return this;
    }

    public AllocateAddressRequest withTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        this.setTagSpecifications(tagSpecifications);
        return this;
    }

    @Override
    public Request<AllocateAddressRequest> getDryRunRequest() {
        Request<AllocateAddressRequest> request = new AllocateAddressRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDomain() != null) {
            sb.append("Domain: ").append(this.getDomain()).append(",");
        }
        if (this.getAddress() != null) {
            sb.append("Address: ").append(this.getAddress()).append(",");
        }
        if (this.getPublicIpv4Pool() != null) {
            sb.append("PublicIpv4Pool: ").append(this.getPublicIpv4Pool()).append(",");
        }
        if (this.getNetworkBorderGroup() != null) {
            sb.append("NetworkBorderGroup: ").append(this.getNetworkBorderGroup()).append(",");
        }
        if (this.getCustomerOwnedIpv4Pool() != null) {
            sb.append("CustomerOwnedIpv4Pool: ").append(this.getCustomerOwnedIpv4Pool()).append(",");
        }
        if (this.getTagSpecifications() != null) {
            sb.append("TagSpecifications: ").append(this.getTagSpecifications());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllocateAddressRequest)) {
            return false;
        }
        AllocateAddressRequest other = (AllocateAddressRequest)obj;
        if (other.getDomain() == null ^ this.getDomain() == null) {
            return false;
        }
        if (other.getDomain() != null && !other.getDomain().equals(this.getDomain())) {
            return false;
        }
        if (other.getAddress() == null ^ this.getAddress() == null) {
            return false;
        }
        if (other.getAddress() != null && !other.getAddress().equals(this.getAddress())) {
            return false;
        }
        if (other.getPublicIpv4Pool() == null ^ this.getPublicIpv4Pool() == null) {
            return false;
        }
        if (other.getPublicIpv4Pool() != null && !other.getPublicIpv4Pool().equals(this.getPublicIpv4Pool())) {
            return false;
        }
        if (other.getNetworkBorderGroup() == null ^ this.getNetworkBorderGroup() == null) {
            return false;
        }
        if (other.getNetworkBorderGroup() != null && !other.getNetworkBorderGroup().equals(this.getNetworkBorderGroup())) {
            return false;
        }
        if (other.getCustomerOwnedIpv4Pool() == null ^ this.getCustomerOwnedIpv4Pool() == null) {
            return false;
        }
        if (other.getCustomerOwnedIpv4Pool() != null && !other.getCustomerOwnedIpv4Pool().equals(this.getCustomerOwnedIpv4Pool())) {
            return false;
        }
        if (other.getTagSpecifications() == null ^ this.getTagSpecifications() == null) {
            return false;
        }
        return other.getTagSpecifications() == null || other.getTagSpecifications().equals(this.getTagSpecifications());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDomain() == null ? 0 : this.getDomain().hashCode());
        hashCode = 31 * hashCode + (this.getAddress() == null ? 0 : this.getAddress().hashCode());
        hashCode = 31 * hashCode + (this.getPublicIpv4Pool() == null ? 0 : this.getPublicIpv4Pool().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkBorderGroup() == null ? 0 : this.getNetworkBorderGroup().hashCode());
        hashCode = 31 * hashCode + (this.getCustomerOwnedIpv4Pool() == null ? 0 : this.getCustomerOwnedIpv4Pool().hashCode());
        hashCode = 31 * hashCode + (this.getTagSpecifications() == null ? 0 : this.getTagSpecifications().hashCode());
        return hashCode;
    }

    public AllocateAddressRequest clone() {
        return (AllocateAddressRequest)super.clone();
    }
}

