/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ec2.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.transform.CreateSnapshotRequestMarshaller;

/**
 * 
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CreateSnapshotRequest extends AmazonWebServiceRequest implements Serializable, Cloneable, DryRunSupportedRequest<CreateSnapshotRequest> {

    /**
     * <p>
     * A description for the snapshot.
     * </p>
     */
    private String description;
    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Outpost on which to create a local snapshot.
     * </p>
     * <ul>
     * <li>
     * <p>
     * To create a snapshot of a volume in a Region, omit this parameter. The snapshot is created in the same Region as
     * the volume.
     * </p>
     * </li>
     * <li>
     * <p>
     * To create a snapshot of a volume on an Outpost and store the snapshot in the Region, omit this parameter. The
     * snapshot is created in the Region for the Outpost.
     * </p>
     * </li>
     * <li>
     * <p>
     * To create a snapshot of a volume on an Outpost and store the snapshot on an Outpost, specify the ARN of the
     * destination Outpost. The snapshot must be created on the same Outpost as the volume.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/snapshots-outposts.html#create-snapshot">Create local
     * snapshots from volumes on an Outpost</a> in the <i>Amazon EBS User Guide</i>.
     * </p>
     */
    private String outpostArn;
    /**
     * <p>
     * The ID of the Amazon EBS volume.
     * </p>
     */
    private String volumeId;
    /**
     * <p>
     * The tags to apply to the snapshot during creation.
     * </p>
     */
    private com.amazonaws.internal.SdkInternalList<TagSpecification> tagSpecifications;

    /**
     * Default constructor for CreateSnapshotRequest object. Callers should use the setter or fluent setter (with...)
     * methods to initialize the object after creating it.
     */
    public CreateSnapshotRequest() {
    }

    /**
     * Constructs a new CreateSnapshotRequest object. Callers should use the setter or fluent setter (with...) methods
     * to initialize any additional object members.
     * 
     * @param volumeId
     *        The ID of the Amazon EBS volume.
     * @param description
     *        A description for the snapshot.
     */
    public CreateSnapshotRequest(String volumeId, String description) {
        setVolumeId(volumeId);
        setDescription(description);
    }

    /**
     * <p>
     * A description for the snapshot.
     * </p>
     * 
     * @param description
     *        A description for the snapshot.
     */

    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * <p>
     * A description for the snapshot.
     * </p>
     * 
     * @return A description for the snapshot.
     */

    public String getDescription() {
        return this.description;
    }

    /**
     * <p>
     * A description for the snapshot.
     * </p>
     * 
     * @param description
     *        A description for the snapshot.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateSnapshotRequest withDescription(String description) {
        setDescription(description);
        return this;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Outpost on which to create a local snapshot.
     * </p>
     * <ul>
     * <li>
     * <p>
     * To create a snapshot of a volume in a Region, omit this parameter. The snapshot is created in the same Region as
     * the volume.
     * </p>
     * </li>
     * <li>
     * <p>
     * To create a snapshot of a volume on an Outpost and store the snapshot in the Region, omit this parameter. The
     * snapshot is created in the Region for the Outpost.
     * </p>
     * </li>
     * <li>
     * <p>
     * To create a snapshot of a volume on an Outpost and store the snapshot on an Outpost, specify the ARN of the
     * destination Outpost. The snapshot must be created on the same Outpost as the volume.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/snapshots-outposts.html#create-snapshot">Create local
     * snapshots from volumes on an Outpost</a> in the <i>Amazon EBS User Guide</i>.
     * </p>
     * 
     * @param outpostArn
     *        The Amazon Resource Name (ARN) of the Outpost on which to create a local snapshot.</p>
     *        <ul>
     *        <li>
     *        <p>
     *        To create a snapshot of a volume in a Region, omit this parameter. The snapshot is created in the same
     *        Region as the volume.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        To create a snapshot of a volume on an Outpost and store the snapshot in the Region, omit this parameter.
     *        The snapshot is created in the Region for the Outpost.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        To create a snapshot of a volume on an Outpost and store the snapshot on an Outpost, specify the ARN of
     *        the destination Outpost. The snapshot must be created on the same Outpost as the volume.
     *        </p>
     *        </li>
     *        </ul>
     *        <p>
     *        For more information, see <a
     *        href="https://docs.aws.amazon.com/ebs/latest/userguide/snapshots-outposts.html#create-snapshot">Create
     *        local snapshots from volumes on an Outpost</a> in the <i>Amazon EBS User Guide</i>.
     */

    public void setOutpostArn(String outpostArn) {
        this.outpostArn = outpostArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Outpost on which to create a local snapshot.
     * </p>
     * <ul>
     * <li>
     * <p>
     * To create a snapshot of a volume in a Region, omit this parameter. The snapshot is created in the same Region as
     * the volume.
     * </p>
     * </li>
     * <li>
     * <p>
     * To create a snapshot of a volume on an Outpost and store the snapshot in the Region, omit this parameter. The
     * snapshot is created in the Region for the Outpost.
     * </p>
     * </li>
     * <li>
     * <p>
     * To create a snapshot of a volume on an Outpost and store the snapshot on an Outpost, specify the ARN of the
     * destination Outpost. The snapshot must be created on the same Outpost as the volume.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/snapshots-outposts.html#create-snapshot">Create local
     * snapshots from volumes on an Outpost</a> in the <i>Amazon EBS User Guide</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Outpost on which to create a local snapshot.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         To create a snapshot of a volume in a Region, omit this parameter. The snapshot is created in the same
     *         Region as the volume.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To create a snapshot of a volume on an Outpost and store the snapshot in the Region, omit this parameter.
     *         The snapshot is created in the Region for the Outpost.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To create a snapshot of a volume on an Outpost and store the snapshot on an Outpost, specify the ARN of
     *         the destination Outpost. The snapshot must be created on the same Outpost as the volume.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/ebs/latest/userguide/snapshots-outposts.html#create-snapshot">Create
     *         local snapshots from volumes on an Outpost</a> in the <i>Amazon EBS User Guide</i>.
     */

    public String getOutpostArn() {
        return this.outpostArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Outpost on which to create a local snapshot.
     * </p>
     * <ul>
     * <li>
     * <p>
     * To create a snapshot of a volume in a Region, omit this parameter. The snapshot is created in the same Region as
     * the volume.
     * </p>
     * </li>
     * <li>
     * <p>
     * To create a snapshot of a volume on an Outpost and store the snapshot in the Region, omit this parameter. The
     * snapshot is created in the Region for the Outpost.
     * </p>
     * </li>
     * <li>
     * <p>
     * To create a snapshot of a volume on an Outpost and store the snapshot on an Outpost, specify the ARN of the
     * destination Outpost. The snapshot must be created on the same Outpost as the volume.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/snapshots-outposts.html#create-snapshot">Create local
     * snapshots from volumes on an Outpost</a> in the <i>Amazon EBS User Guide</i>.
     * </p>
     * 
     * @param outpostArn
     *        The Amazon Resource Name (ARN) of the Outpost on which to create a local snapshot.</p>
     *        <ul>
     *        <li>
     *        <p>
     *        To create a snapshot of a volume in a Region, omit this parameter. The snapshot is created in the same
     *        Region as the volume.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        To create a snapshot of a volume on an Outpost and store the snapshot in the Region, omit this parameter.
     *        The snapshot is created in the Region for the Outpost.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        To create a snapshot of a volume on an Outpost and store the snapshot on an Outpost, specify the ARN of
     *        the destination Outpost. The snapshot must be created on the same Outpost as the volume.
     *        </p>
     *        </li>
     *        </ul>
     *        <p>
     *        For more information, see <a
     *        href="https://docs.aws.amazon.com/ebs/latest/userguide/snapshots-outposts.html#create-snapshot">Create
     *        local snapshots from volumes on an Outpost</a> in the <i>Amazon EBS User Guide</i>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateSnapshotRequest withOutpostArn(String outpostArn) {
        setOutpostArn(outpostArn);
        return this;
    }

    /**
     * <p>
     * The ID of the Amazon EBS volume.
     * </p>
     * 
     * @param volumeId
     *        The ID of the Amazon EBS volume.
     */

    public void setVolumeId(String volumeId) {
        this.volumeId = volumeId;
    }

    /**
     * <p>
     * The ID of the Amazon EBS volume.
     * </p>
     * 
     * @return The ID of the Amazon EBS volume.
     */

    public String getVolumeId() {
        return this.volumeId;
    }

    /**
     * <p>
     * The ID of the Amazon EBS volume.
     * </p>
     * 
     * @param volumeId
     *        The ID of the Amazon EBS volume.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateSnapshotRequest withVolumeId(String volumeId) {
        setVolumeId(volumeId);
        return this;
    }

    /**
     * <p>
     * The tags to apply to the snapshot during creation.
     * </p>
     * 
     * @return The tags to apply to the snapshot during creation.
     */

    public java.util.List<TagSpecification> getTagSpecifications() {
        if (tagSpecifications == null) {
            tagSpecifications = new com.amazonaws.internal.SdkInternalList<TagSpecification>();
        }
        return tagSpecifications;
    }

    /**
     * <p>
     * The tags to apply to the snapshot during creation.
     * </p>
     * 
     * @param tagSpecifications
     *        The tags to apply to the snapshot during creation.
     */

    public void setTagSpecifications(java.util.Collection<TagSpecification> tagSpecifications) {
        if (tagSpecifications == null) {
            this.tagSpecifications = null;
            return;
        }

        this.tagSpecifications = new com.amazonaws.internal.SdkInternalList<TagSpecification>(tagSpecifications);
    }

    /**
     * <p>
     * The tags to apply to the snapshot during creation.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setTagSpecifications(java.util.Collection)} or {@link #withTagSpecifications(java.util.Collection)} if
     * you want to override the existing values.
     * </p>
     * 
     * @param tagSpecifications
     *        The tags to apply to the snapshot during creation.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateSnapshotRequest withTagSpecifications(TagSpecification... tagSpecifications) {
        if (this.tagSpecifications == null) {
            setTagSpecifications(new com.amazonaws.internal.SdkInternalList<TagSpecification>(tagSpecifications.length));
        }
        for (TagSpecification ele : tagSpecifications) {
            this.tagSpecifications.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The tags to apply to the snapshot during creation.
     * </p>
     * 
     * @param tagSpecifications
     *        The tags to apply to the snapshot during creation.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateSnapshotRequest withTagSpecifications(java.util.Collection<TagSpecification> tagSpecifications) {
        setTagSpecifications(tagSpecifications);
        return this;
    }

    /**
     * This method is intended for internal use only. Returns the marshaled request configured with additional
     * parameters to enable operation dry-run.
     */
    @Override
    public Request<CreateSnapshotRequest> getDryRunRequest() {
        Request<CreateSnapshotRequest> request = new CreateSnapshotRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getDescription() != null)
            sb.append("Description: ").append(getDescription()).append(",");
        if (getOutpostArn() != null)
            sb.append("OutpostArn: ").append(getOutpostArn()).append(",");
        if (getVolumeId() != null)
            sb.append("VolumeId: ").append(getVolumeId()).append(",");
        if (getTagSpecifications() != null)
            sb.append("TagSpecifications: ").append(getTagSpecifications());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CreateSnapshotRequest == false)
            return false;
        CreateSnapshotRequest other = (CreateSnapshotRequest) obj;
        if (other.getDescription() == null ^ this.getDescription() == null)
            return false;
        if (other.getDescription() != null && other.getDescription().equals(this.getDescription()) == false)
            return false;
        if (other.getOutpostArn() == null ^ this.getOutpostArn() == null)
            return false;
        if (other.getOutpostArn() != null && other.getOutpostArn().equals(this.getOutpostArn()) == false)
            return false;
        if (other.getVolumeId() == null ^ this.getVolumeId() == null)
            return false;
        if (other.getVolumeId() != null && other.getVolumeId().equals(this.getVolumeId()) == false)
            return false;
        if (other.getTagSpecifications() == null ^ this.getTagSpecifications() == null)
            return false;
        if (other.getTagSpecifications() != null && other.getTagSpecifications().equals(this.getTagSpecifications()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getDescription() == null) ? 0 : getDescription().hashCode());
        hashCode = prime * hashCode + ((getOutpostArn() == null) ? 0 : getOutpostArn().hashCode());
        hashCode = prime * hashCode + ((getVolumeId() == null) ? 0 : getVolumeId().hashCode());
        hashCode = prime * hashCode + ((getTagSpecifications() == null) ? 0 : getTagSpecifications().hashCode());
        return hashCode;
    }

    @Override
    public CreateSnapshotRequest clone() {
        return (CreateSnapshotRequest) super.clone();
    }
}
