/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.MemoryMiB;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class MemoryMiBStaxUnmarshaller
implements Unmarshaller<MemoryMiB, StaxUnmarshallerContext> {
    private static MemoryMiBStaxUnmarshaller instance;

    public MemoryMiB unmarshall(StaxUnmarshallerContext context) throws Exception {
        MemoryMiB memoryMiB = new MemoryMiB();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return memoryMiB;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("min", targetDepth)) {
                    memoryMiB.setMin(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("max", targetDepth)) continue;
                memoryMiB.setMax(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return memoryMiB;
    }

    public static MemoryMiBStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new MemoryMiBStaxUnmarshaller();
        }
        return instance;
    }
}

