/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.Image;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DescribeImagesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private SdkInternalList<Image> images;
    private String nextToken;

    public List<Image> getImages() {
        if (this.images == null) {
            this.images = new SdkInternalList();
        }
        return this.images;
    }

    public void setImages(Collection<Image> images) {
        if (images == null) {
            this.images = null;
            return;
        }
        this.images = new SdkInternalList(images);
    }

    public DescribeImagesResult withImages(Image ... images) {
        if (this.images == null) {
            this.setImages((Collection<Image>)new SdkInternalList(images.length));
        }
        for (Image ele : images) {
            this.images.add((Object)ele);
        }
        return this;
    }

    public DescribeImagesResult withImages(Collection<Image> images) {
        this.setImages(images);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public DescribeImagesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getImages() != null) {
            sb.append("Images: ").append(this.getImages()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImagesResult)) {
            return false;
        }
        DescribeImagesResult other = (DescribeImagesResult)obj;
        if (other.getImages() == null ^ this.getImages() == null) {
            return false;
        }
        if (other.getImages() != null && !other.getImages().equals(this.getImages())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getImages() == null ? 0 : this.getImages().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public DescribeImagesResult clone() {
        try {
            return (DescribeImagesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

