/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.BlockDeviceMapping;
import com.amazonaws.services.ec2.model.ImageAttribute;
import com.amazonaws.services.ec2.model.LaunchPermission;
import com.amazonaws.services.ec2.model.ProductCode;
import com.amazonaws.services.ec2.model.transform.BlockDeviceMappingStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.LaunchPermissionStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.ProductCodeStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class ImageAttributeStaxUnmarshaller
implements Unmarshaller<ImageAttribute, StaxUnmarshallerContext> {
    private static ImageAttributeStaxUnmarshaller instance;

    public ImageAttribute unmarshall(StaxUnmarshallerContext context) throws Exception {
        ImageAttribute imageAttribute = new ImageAttribute();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return imageAttribute;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("blockDeviceMapping", targetDepth)) {
                    imageAttribute.withBlockDeviceMappings(new ArrayList<BlockDeviceMapping>());
                    continue;
                }
                if (context.testExpression("blockDeviceMapping/item", targetDepth)) {
                    imageAttribute.withBlockDeviceMappings(BlockDeviceMappingStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("imageId", targetDepth)) {
                    imageAttribute.setImageId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("launchPermission", targetDepth)) {
                    imageAttribute.withLaunchPermissions(new ArrayList<LaunchPermission>());
                    continue;
                }
                if (context.testExpression("launchPermission/item", targetDepth)) {
                    imageAttribute.withLaunchPermissions(LaunchPermissionStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("productCodes", targetDepth)) {
                    imageAttribute.withProductCodes(new ArrayList<ProductCode>());
                    continue;
                }
                if (context.testExpression("productCodes/item", targetDepth)) {
                    imageAttribute.withProductCodes(ProductCodeStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("description/value", targetDepth)) {
                    imageAttribute.setDescription(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("kernel/value", targetDepth)) {
                    imageAttribute.setKernelId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ramdisk/value", targetDepth)) {
                    imageAttribute.setRamdiskId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("sriovNetSupport/value", targetDepth)) {
                    imageAttribute.setSriovNetSupport(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("bootMode/value", targetDepth)) {
                    imageAttribute.setBootMode(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("tpmSupport/value", targetDepth)) {
                    imageAttribute.setTpmSupport(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("uefiData/value", targetDepth)) {
                    imageAttribute.setUefiData(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("lastLaunchedTime/value", targetDepth)) {
                    imageAttribute.setLastLaunchedTime(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("imdsSupport/value", targetDepth)) {
                    imageAttribute.setImdsSupport(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("deregistrationProtection/value", targetDepth)) continue;
                imageAttribute.setDeregistrationProtection(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return imageAttribute;
    }

    public static ImageAttributeStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ImageAttributeStaxUnmarshaller();
        }
        return instance;
    }
}

