/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.GetIpamDiscoveredAccountsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class GetIpamDiscoveredAccountsRequestMarshaller
implements Marshaller<Request<GetIpamDiscoveredAccountsRequest>, GetIpamDiscoveredAccountsRequest> {
    public Request<GetIpamDiscoveredAccountsRequest> marshall(GetIpamDiscoveredAccountsRequest getIpamDiscoveredAccountsRequest) {
        SdkInternalList getIpamDiscoveredAccountsRequestFiltersList;
        if (getIpamDiscoveredAccountsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getIpamDiscoveredAccountsRequest, "AmazonEC2");
        request.addParameter("Action", "GetIpamDiscoveredAccounts");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (getIpamDiscoveredAccountsRequest.getIpamResourceDiscoveryId() != null) {
            request.addParameter("IpamResourceDiscoveryId", StringUtils.fromString((String)getIpamDiscoveredAccountsRequest.getIpamResourceDiscoveryId()));
        }
        if (getIpamDiscoveredAccountsRequest.getDiscoveryRegion() != null) {
            request.addParameter("DiscoveryRegion", StringUtils.fromString((String)getIpamDiscoveredAccountsRequest.getDiscoveryRegion()));
        }
        if (!(getIpamDiscoveredAccountsRequestFiltersList = (SdkInternalList)getIpamDiscoveredAccountsRequest.getFilters()).isEmpty() || !getIpamDiscoveredAccountsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter getIpamDiscoveredAccountsRequestFiltersListValue : getIpamDiscoveredAccountsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (getIpamDiscoveredAccountsRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)getIpamDiscoveredAccountsRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)getIpamDiscoveredAccountsRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (getIpamDiscoveredAccountsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)getIpamDiscoveredAccountsRequest.getNextToken()));
        }
        if (getIpamDiscoveredAccountsRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)getIpamDiscoveredAccountsRequest.getMaxResults()));
        }
        return request;
    }
}

