/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.StartNetworkInsightsAnalysisRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.IdempotentUtils;
import com.amazonaws.util.StringUtils;

public class StartNetworkInsightsAnalysisRequestMarshaller
implements Marshaller<Request<StartNetworkInsightsAnalysisRequest>, StartNetworkInsightsAnalysisRequest> {
    public Request<StartNetworkInsightsAnalysisRequest> marshall(StartNetworkInsightsAnalysisRequest startNetworkInsightsAnalysisRequest) {
        SdkInternalList startNetworkInsightsAnalysisRequestTagSpecificationsList;
        SdkInternalList startNetworkInsightsAnalysisRequestFilterInArnsList;
        SdkInternalList startNetworkInsightsAnalysisRequestAdditionalAccountsList;
        if (startNetworkInsightsAnalysisRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)startNetworkInsightsAnalysisRequest, "AmazonEC2");
        request.addParameter("Action", "StartNetworkInsightsAnalysis");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (startNetworkInsightsAnalysisRequest.getNetworkInsightsPathId() != null) {
            request.addParameter("NetworkInsightsPathId", StringUtils.fromString((String)startNetworkInsightsAnalysisRequest.getNetworkInsightsPathId()));
        }
        if (!(startNetworkInsightsAnalysisRequestAdditionalAccountsList = (SdkInternalList)startNetworkInsightsAnalysisRequest.getAdditionalAccounts()).isEmpty() || !startNetworkInsightsAnalysisRequestAdditionalAccountsList.isAutoConstruct()) {
            int additionalAccountsListIndex = 1;
            for (Object startNetworkInsightsAnalysisRequestAdditionalAccountsListValue : startNetworkInsightsAnalysisRequestAdditionalAccountsList) {
                if (startNetworkInsightsAnalysisRequestAdditionalAccountsListValue != null) {
                    request.addParameter("AdditionalAccount." + additionalAccountsListIndex, StringUtils.fromString((String)startNetworkInsightsAnalysisRequestAdditionalAccountsListValue));
                }
                ++additionalAccountsListIndex;
            }
        }
        if (!(startNetworkInsightsAnalysisRequestFilterInArnsList = (SdkInternalList)startNetworkInsightsAnalysisRequest.getFilterInArns()).isEmpty() || !startNetworkInsightsAnalysisRequestFilterInArnsList.isAutoConstruct()) {
            int filterInArnsListIndex = 1;
            for (String startNetworkInsightsAnalysisRequestFilterInArnsListValue : startNetworkInsightsAnalysisRequestFilterInArnsList) {
                if (startNetworkInsightsAnalysisRequestFilterInArnsListValue != null) {
                    request.addParameter("FilterInArn." + filterInArnsListIndex, StringUtils.fromString((String)startNetworkInsightsAnalysisRequestFilterInArnsListValue));
                }
                ++filterInArnsListIndex;
            }
        }
        if (!(startNetworkInsightsAnalysisRequestTagSpecificationsList = (SdkInternalList)startNetworkInsightsAnalysisRequest.getTagSpecifications()).isEmpty() || !startNetworkInsightsAnalysisRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification startNetworkInsightsAnalysisRequestTagSpecificationsListValue : startNetworkInsightsAnalysisRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (startNetworkInsightsAnalysisRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString((String)startNetworkInsightsAnalysisRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)startNetworkInsightsAnalysisRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        request.addParameter("ClientToken", IdempotentUtils.resolveString((String)startNetworkInsightsAnalysisRequest.getClientToken()));
        return request;
    }
}

